<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\otdr;

use app\util\SMTUtil;

use app\services\otdr\SMTAcquisitionParametersDto;

/**
 * Measurement on undeclared link acquisition parameters.
 * 
 * @author Sylvain Desplat
 */
class SMTStartOtdrMeasureOnDemandParametersDto extends SMTAcquisitionParametersDto
{
    /**
     * @var string
     */
    protected $modulePosition= NULL;
    
    /**
     * @var int
     */
    protected $portNumber = NULL;
    
    /**
     * @var number
     */
    protected $linkId = NULL;
    
    /**
     * @var number
     */
    protected $testId = NULL;    
        
    /** 
     * @var String
     */
    protected $linkName = NULL;
    
    /**
     * @var boolean
     */
    protected $acquisitionModeAuto = TRUE;
    
    /**
     * @var string
     */
    protected $functionName = NULL;    
    
    /**
     * Optional Parameter to launch the measure with the given operation Id.
     * @var String
     */
    protected $operationId = NULL;
    
    /**
     * @var boolean
     */
    protected $shortAcq = NULL;
    
    public function setOperationId( $operationId )
    {
    	$this->operationId = $operationId;
    }
    
    public function getOperationId()
    {
        return $this->operationId;
    } 
    
    public function setModulePosition( $modulePosition )
    {
    	$this->modulePosition = $modulePosition;
    }
    
    public function getModulePosition()
    {        
    	return $this->modulePosition;
    } 
    
    public function getModuleRunningNumber()
    {
    	return substr( $this->modulePosition, -1);
    }
    
    public function setPortNumber( $portNumber )
    {
    	$this->portNumber = SMTUtil::convertToInt( $portNumber );
    }
    
    public function getPortNumber()
    {
        return $this->portNumber !== NULL ? intval($this->portNumber) : NULL;
    }    

    public function setLinkId( $linkId )
    {
    	$this->linkId = SMTUtil::convertToInt( $linkId );
    }
    
    public function getLinkId()
    {
    	return $this->linkId;
    }    
    
    public function setTestId( $testId )
    {
    	$this->testId = ($testId != NULL)? SMTUtil::convertToInt( $testId ) : NULL;
    }
    
    public function getTestId()
    {
    	return $this->testId;
    }    
    
    public function setLinkName( $linkName )
    {
    	$this->linkName = $linkName;
    }
    
    public function getLinkName()
    {
    	return $this->linkName;
    }
    
    /**
     *
     * @param boolean $autoconfig
     */
    public function setAcquisitionModeAuto( $acquisitionModeAuto )
    {
    	$this->acquisitionModeAuto = $acquisitionModeAuto;
    }
    
    /**
     *
     * @return boolean
     */
    public function isAcquisitionModeAuto()
    {
    	return $this->acquisitionModeAuto;
    }
    
    /**
     *
     * @return string AUTO or MANUAL
     */
    public function getAcquisitionMode()
    {
    	return ( $this->acquisitionModeAuto )? "AUTO" : "MANUAL";
    }
    
    /**
     * @param string $functionName
     */
    public function setFunctionName( $functionName )
    {
    	$this->functionName = $functionName;
    }
    /**
     * @return $range
     */
    public function getFunctionName()
    {
    	return $this->functionName;
    }
    
    /**
     * @param string $shortAcq
     */
    public function setShortAcq( $shortAcq )
    {
    	$this->shortAcq= $shortAcq;
    }
    /**
     * @return $shortAcq
     */
    public function getShortAcq()
    {
    	return $this->shortAcq != NULL? $this->shortAcq : false;
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }    
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\monitoring\SMTLinkTestDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }    
}
?>