<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright VIAVI Solutions 2018. All rights reserved.
// *********************************************************
namespace app\services\monitoring;

use app\util\SMTRwDto;

/**
 * List of hysteresis according the alarm attenuation threshold
 *
 * @author Sylvain Desplat
 */
class SMTOtuTestThresholdHysteresisListDto extends SMTRwDto
{
	
	/**
	 * @SMTAttributeInfosAnnotation(classname='app\services\monitoring\SMTOtuTestThresholdHysteresisDto',islist='true')
	 * @var array app\services\monitoring\SMTOtuTestThresholdHysteresisDto
	 */
	protected $hysteresisList = array();
	
	/**
	 * Add the given hysteresis
	 *
	 * @param float $attenuation
	 * @param float $hysteresis
	 */
	public function addHysteresis( $attenuationThreshold, $hysteresis )
	{
		$hysteresisDto = new SMTOtuTestThresholdHysteresisDto();
		$hysteresisDto->setAttenuationThreshold($attenuationThreshold);
		$hysteresisDto->setHysteresis($hysteresis);
		
		array_push( $this->hysteresisList, $hysteresisDto);
	}
	
	/**
	 * hysteresis for a given attenuation
	 *
	 * @param float $attenuationThreshold
	 * 
	 * @return float hysteresis
	 */
	public function getHysteresis($attenuationThreshold)
	{
		$hysteresis = SMTOtuTestThresholdHysteresisDto::DEFAULT_HYSTERESIS;
		$found = FALSE;
		
		foreach ( $this->hysteresisList as $val=>$hyst)
		{
			if ( $attenuationThreshold<= $val )
			{
				$hysteresis = $hyst;
				$found = TRUE;
				break;
			}
		}
		
		//hysteresis par defaut
		if (!$found && ($this->hysteresisList[0]->getAttenuationThreshold() == 0) )
		{
			$hysteresis = $this->hysteresisList[0]->getHysteresis();
		}
		
		return $hysteresis;
	}
	
	
	/**
	 * Serialize as Json data the object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json array.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\monitoring\SMTOtuMonitoringTestThresholdDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}

?>