<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright VIAVI Solutions 2018. All rights reserved.
// *********************************************************
namespace app\services\monitoring;

use app\util\SMTRwDto;

/**
 * hysteresis of the attenuation threshold
 *
 * @author Sylvain Desplat
 */
class SMTOtuTestThresholdHysteresisDto extends SMTRwDto
{
	/**
	 * no current port selected: if a port is selected, deselect it
	 *
	 * @var integer
	 */
	const DEFAULT_HYSTERESIS = 0.1;
	
	protected $hysteresis = self::DEFAULT_HYSTERESIS;
	
	protected $attenuationThreshold = 0;
	
	/**
	 * @param string $hysteresis
	 */
	public function setHysteresis( $hysteresis)
	{
		if ( is_numeric( $hysteresis) )
		{
			$this->hysteresis= floatval($hysteresis);
		}
		else
		{
			$this->hysteresis= self::DEFAULT_HYSTERESIS;
		}
	}
	
	public function getHysteresis()
	{
		return $this->hysteresis;
	}
	
	/**
	 * @param string $attenuation
	 */
	public function setAttenuationThreshold( $attenuationThreshold)
	{
		if ( is_numeric( $attenuationThreshold) )
		{
			$this->attenuationThreshold= floatval($attenuationThreshold);
		}
		else
		{
			$this->attenuationThreshold= 0;
		}
	}
	
	public function getAttenuationThreshold()
	{
		return $this->attenuationThreshold;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\monitoring\SMTOtuMonitoringTestThresholdDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}

?>