<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\util\SMTDto;

/**
 * DTO for SmartAccessAnywhere
 * 
 * @author Sylvain Desplat
 */
class SMTSmartAccessAnywhereDto extends SMTDto
{	
	/**
	 * backup file name
	 * 
	 * @var string
	 */
	protected $accessCode = NULL;
	
	/**
	 * Whether a connection is being established
	 * @var boolean
	 */
	protected $connectionUnderModification = FALSE;

	/**
	 * Whether the saa connection failed
	 * @var boolean
	 */
	protected $connectionFailure = FALSE;
	
	/**
	 * Set whether a connection is being established with SmartAccessAnywhere
	 *
	 * @param boolean $connectionPending
	 */
	public function setConnectionUnderModification( $connectionUnderModification )
	{
		$this->connectionUnderModification = $connectionUnderModification;
	}

	/**
	 * Set whether a connection is being established with SmartAccessAnywhere
	 *
	 * @return boolean
	 */
	public function isConnectionUnderModification()
	{
		return $this->connectionUnderModification;
	}
    
	/**
	 * Set whether saa connection failed
	 *
	 * @param boolean $connectionPending
	 */
	public function setConnectionFailure( $failure )
	{
		$this->connectionFailure = $failure;
	}
	
	/**
	 * Whether saa connection failed
	 *
	 * @return boolean
	 */
	public function isConnectionFailure()
	{
		return $this->connectionFailure;
	}
	
	/**
	 * Set SmartAccessAnywhere access code
	 *
	 * @param string $accessCode
	 */
	public function setAccessCode( $accessCode )
	{
		$this->accessCode = $accessCode;
	}
	
	/**
	 * Get access code
	 *
	 * @return string $accessCode
	 */
	public function getAccessCode()
	{
		return $this->accessCode;
	}
	
	/**
	 * Returns the dto class name.
	 *
	 * @return the dto class name.
	 */
	public static function getClass()
	{
		return __CLASS__;
	}
	
	/**
	 * Serialize as Json data (array) the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json array.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\\services\\maintenance\SMTSmartAccessAnywhereDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}


?>