<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright JDSU 2016. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\util\SMTRwDto;
use app\serviceshelper\maintenance\SMTLicence;

/**
 * DTO to retrieve OTU certificates info
 *
 * @author Sylvain Desplat
 */
class SMTCertificateDto extends SMTRwDto
{
	/**
	 * Whether the ssh keyt root access option is active
	 * 
	 * @var string
	 */
	protected $sshKeyRootAccess = SMTLicence::SSH_KEY_ROOT_ACCESS_OFF;	
	
	/**
	 * Whether the enhanced security option is active
	 * @var string
	 */
	protected $enhancedSecurity = SMTLicence::ENHANCED_SECURITY_OFF;
	
	/**
	 * Public keys list stored in an array
	 *
	 * @var string[]
	 */
	protected $publicKeys = array();
	
	/**
	 * Set array of ssh public keys
	 *
	 * @param string[] $customFirewallConfig
	*/
	public function setSshPublicKeys( array $publicKeys )
	{
		$this->publicKeys = $publicKeys;
	}
	
	/**
	 * @return String[]
	 */
	public function getSshPublicKeys()
	{
		return $this->publicKeys;
	}
	
    /**
     * Set whether the ssh Key Root Access option is activated
     *
     * @param string
     */
    public function setSshKeyRootAccess( $sshKeyRootAccess )
    {
    	$this->sshKeyRootAccess = $sshKeyRootAccess;
    }
    
    /**
     * Whether the ssh Key Root Access option is activated
     * @return string
     */
    public function getSshKeyRootAccess()
    {
    	return $this->sshKeyRootAccess;
    }
    
    /**
     * Set whether the enhanced security option is activated
     *
     * @param string
     */
    public function setEnhancedSecurity( $security )
    {
    	$this->enhancedSecurity = $security;
    }
    
    /**
     * Whether the enhanced security option is activated
     * @return string
     */
    public function getEnhancedSecurity()
    {
    	return $this->enhancedSecurity;
    }    
    
	/**
	 * Returns the dto class name.
	 *
	 * @return the dto class name.
	 */
	public static function getClass()
	{
		return __CLASS__;
	}
	
	/**
	 * Serialize as Json data (array) the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json array.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dto class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\\services\\maintenance\SMTBackupDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}

?>