<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\autotest\otu;

use app\util\SMTRwDto;
use app\util\SMTUtil;

/**
 * Otu autotest dto
 * 
 * @author Sylvain Desplat
 */
class SMTOtuAutotestDto extends SMTRwDto
{        
    /**
     * Timestamp of autotest start time in seconds
     * 
     * @var number
     */
    protected $date;
    
    /**
     * Autotest duration in seconds
     * 
     * @var number
     */
    protected $durationSec;
         
    /**
     * Autotest sequence last run date in seconds
     *
     * @var number
     */
    protected $sequencerLastRunDate;    
    
    /**
     * Autotest success ( true / false )
     *
     * @var string
     */
    protected $success;    
    
    /**
     * Autotest summary file name
     *
     * @var string
     */    
    protected $autotestSummaryFileName;
    
    /**
     * Alarm creation date as a string (not used just added to map info sent by OTU)
     *
     * @var string
     */
    protected $dateHuman;
    
    /**
     * Operation Id (not used just added to map info sent by OTU)
     *
     * @var string
     */
    protected $operationId;
    
    /**
     * Get autotest end date
     *
     * @return number
     */
    public function getEndDate()
    {
    	return $this->date;
    }
    
    /**
     * Get autotest end date in seconds in UTC
     *
     * @param \SQLite3 $dbConnection
     * @return integer/float autotest end date in seconds in UTC
     */
    public function getEndDateUTC( \SQLite3 $dbConnection )
    {
    	return SMTUtil::getTimestampUTC( $this->date, $dbConnection );
    }
    
    /**
     * Get autotest duration
     *
     * @return number
     */
    public function getDurationSec()
    {
    	return $this->durationSec;
    }
    
    /**
     * Get sequencer last run date in seconds
     *
     * @return number
     */
    public function getSequencerLastRunDateSec()
    {
    	return $this->sequencerLastRunDate;
    }
    
    /**
     * Get sequencer last run date in seconds in UTC
     *
     * @param \SQLite3 $dbConnection
     * @return integer/float sequencer last run date in seconds in UTC
     */
    public function getSequencerLastRunDateSecUTC( \SQLite3 $dbConnection )
    {
    	return SMTUtil::getTimestampUTC( $this->sequencerLastRunDate, $dbConnection );
    }
    
    /**
     * Whether autotest is successful
     *
     * @return boolean
     */
    public function isAutotestSuccessful()
    {
        return filter_var( $this->success, FILTER_VALIDATE_BOOLEAN);
    }
    
    /**
     * Autotest summary file name
     * 
     * @return string
     */
    public function getAutotestSummaryFileName()
    {
    	return $this->autotestSummaryFileName;
    }
    
    
    /**
     * Serialize as Json data the object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json array.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\autotest\SMTAutotestSetupDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }    
}
?>