<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2019. All rights reserved.
// *********************************************************
namespace app\services\api;

/**
 * 
 *
 * @author sdesplat
 */
class SMTApiSnmpDto extends SMTApiDto
{
	/**
	 * Manager Id
	 *
	 * @var integer
	 */
	protected $id = 0;
	
	/**
	 * SNMP address
	 *
	 * @var string
	 */
	protected $address;
	
	/**
	 * SNMP Community
	 *
	 * @var string
	 */
	protected $community;
	
	/**
	 * Port Number
	 *
	 * @var integer
	 */
	protected $port;	
	
	public function setPort($port)
	{
		$this->port= intval($port);
	}
	
	public function getPort()
	{
		return intval($this->port);
	}
	
	public function setCommunity($community)
	{
		$this->community= $community;
	}
	
	public function getCommunity()
	{
		return $this->community;
	}
	
	public function setAddress($address)
	{
		$this->address= $address;
	}
	
	public function getAddress()
	{
		return $this->address;
	}
	
	public function setId($id)
	{
		$this->id= intval($id);
	}
	
	public function getId()
	{
		return intval($this->id);
	}
	
	public function isConfigValid()
	{
		return (strlen($this->address) > 0) && (strlen($this->community) > 0) && ($this->port > 0);
	}
	
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE);
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\api\SMTApiLinkDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}