<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2019. All rights reserved.
// *********************************************************
namespace app\services\api;


/**
 * 
 * @author sdesplat
 *
 */
class SMTApiPortAlarmStatusDto extends SMTApiDto
{
	/**
	 * Port Number
	 *
	 * @var integer
	 */
	protected $portNumber;
	
	/**
	 * alarm severity
	 *
	 * @var integer
	 */
	protected $severity;
	
	/**
	 * alarm type
	 * @var string
	 */
	protected $type;
	
	/**
	 * alarm date in UTC
	 * @var integer
	 */
	protected $timestamp;
	
	/**
	 * alarm distance
	 *
	 * @var float
	 */
	protected $distance;
	
	/**
	 * Probale cause
	 * @var string
	 */
	protected $probableCause;

	public function setPortNumber($portNumber)
	{
		$this->portNumber= intval($portNumber);
	}
	
	/**
	 * Alarm severity
	 *
	 * @param integer $severity
	 */
	public function setSeverity( $severity )
	{
		$this->severity= intval($severity);
	}
	
	/**
	 * Alarm type
	 *
	 * @param string $otuType
	 */
	public function setType( $alarmType )
	{
		$this->type = $alarmType;
	}
	/**
	 * Alarm timestamp
	 *
	 * @param string $timestamp
	 */
	public function setTimestamp( $timestamp )
	{
		$this->timestamp= intval($timestamp);
	}
	/**
	 * Alarm distance
	 *
	 * @param string $timestamp
	 */
	public function setDistance( $distance )
	{
		$this->distance = floatval($distance);
	}
	/**
	 * Alarm probable cause
	 *
	 * @param string $timestamp
	 */
	public function setProbableCause( $probableCause )
	{
		$this->probableCause= $probableCause;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE);
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}