<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2019. All rights reserved.
// *********************************************************
namespace app\services\api;


/**
 * 
 * @author sdesplat
 *
 */
class SMTApiOpticalModuleDto extends SMTApiDto
{
	/**
	 * OTU serial number
	 *
	 * @var string
	 */
	protected $serialNumber;
	
	/**
	 * Optical module position 
	 */
	protected $position;
	
	/**
	 * OTU type label
	 * @var string
	 */
	protected $type;
	
	/**
	 * Optical module wavelegnths
	 * @var string
	 */
	protected $wavelengths = array();
	
	public function setSerialNumber($serialNumber)
	{
		$this->serialNumber= $serialNumber;
	}
	
	/**
	 * Optical module position
	 *
	 * @param string $position
	 */
	public function setPosition( $position)
	{
		$this->position= $position;
	}
	
	/**
	 * OTU type
	 *
	 * @param string $otuType
	 */
	public function setType( $otuType )
	{
		$this->type = $otuType;
	}
	
	/**
	 * Optical module wavelengths
	 *
	 * @param string $wavelengths
	 */
	public function setWavelengths( $wavelengths)
	{
		
		if ( strlen($wavelengths) > 0 )
		{
			$wavelengthsList = explode(" ", $wavelengths);
			if ( $wavelengthsList !== FALSE )
			{
				if ( is_array($wavelengthsList) )
				{
					$this->wavelengths = array_map( 'intval', $wavelengthsList);
				}
				else
				{
					array_push($this->wavelengths, intval($wavelengths) );
				}
			}
		}
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE);
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}