<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2019. All rights reserved.
// *********************************************************
namespace app\services\api;


/**
 * 
 * @author sdesplat
 *
 */
class SMTApiIpv4Dto extends SMTApiDto
{
    /**
     * @var boolean
     */
    protected $dhcp;
    /**
     * @var string
     */    
    protected $ip;
    /**
     * @var string
     */    
    protected $subnet;
    /**
     * @var string
     */    
    protected $gateway;
    /**
     * @var string
     */    
    protected $domain;
    /**
     * @var string
     */    
    protected $dns;
        
    public function setDhcp( $dhcp )
    {
    	$this->dhcp = filter_var( $dhcp, FILTER_VALIDATE_BOOLEAN );
    }
        
    public function setIp( $ip )
    {
    	$this->ip = $ip;
    }
        
    public function setSubnet( $subnet )
    {
    	$this->subnet = $subnet;
    }    
    
    public function setGateway( $gateway )
    {
    	$this->gateway = $gateway;
    }

    public function setDomain( $domain )
    {
    	$this->domain = $domain;
    }

    public function setDns( $dns )
    {
    	$this->dns = $dns;
    }    
    
    public function isDHCP()
    {        
    	return $this->dhcp;
    }
    
    public function getIp()
    {
        return $this->ip;
    }
    
    public function getSubnet()
    {
    	return $this->subnet;
    }
    
    public function getGateway()
    {
    	return $this->gateway;
    }
    
    public function getDomain()
    {
    	return $this->domain;
    }
    
    public function getDns()
    {
    	return $this->dns;
    }    
        
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties, FALSE);
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\api\SMTApiLinkDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }
}


?>