<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright JDSU 2016. All rights reserved.
// *********************************************************
namespace app\services\alarm\webservice;

use app\util\SMTRwDto;

/**
 * Attenuation optical alarm dto class for web service notification
 * 
 * @author Sylvain Desplat
 */
class SMTWsOpticalAlarmAttenuationDto extends SMTRwDto
{
    /**
     * alarm Link
     *
     * @var string
     */
    protected $linkName;
    
    
    /**
     * @var float
     */
    protected $distanceKm = NULL;
       
    /**
     * Level in dB
     * 
     * @var float
     */
    protected $leveldB = NULL;
    
    /**
     * alarm longitude (decimal degree)
     *
     * @var float
     */
    protected $gpsLong = NULL;
    /**
     * alarm latitude (decimal degree)
     *
     * @var float
     */
    protected $gpsLat = NULL;

    
    /**
     * distance in km
     * 
     * @return float
     */
    public function getDistanceKm()
    {
    	return $this->distanceKm;
    }
    
    /**
     * set distance in km
     *
     * @param float
     */
    public function setDistanceKm( $distance )
    {
    	return $this->distanceKm = $distance;
    }
    
    /**
     * Level in dB
     * 
     * @return float
     */
    public function getLevelDb()
    {
    	return $this->leveldB;
    }    
    
    /**
     * Set Level in dB
     *
     * @param float
     */
    public function setLevelDb( $level )
    {
    	return $this->leveldB = $level;
    }
    
    /**
     * Link name
     * @return string
     */
    public function getLinkName()
    {
    	return $this->linkName;
    }
    
    /**
     * Set link name
     * @param string
     */
    public function setLinkName($linkName)
    {
    	$this->linkName = $linkName;
    }    
    
    /**
     * Gps longitude in decimal degree
     *
     * @return float
     */
    public function getGpsLong()
    {
    	return $this->gpsLong;
    }
    
    /**
     * Set Gps longitude in decimal degree
     *
     * @param float
     */
    public function setGpsLong($gpsLong)
    {
    	return $this->gpsLong = $gpsLong;
    }    
    
    /**
     * Gps latitude in decimal degree
     *
     * @return float
     */
    public function getGpsLat()
    {
    	return $this->gpsLat;
    }    
    
    /**
     * Set Gps latitude in decimal degree
     *
     * @param float
     */
    public function setGpsLat($gpsLat)
    {
    	return $this->gpsLat = $gpsLat;
    }    
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\alarm\otu\SMTOtuOpticalAlarmAttenuationDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array, FALSE );
    }
}
?>