<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\alarm\otu;

use app\serviceshelper\alarm\SMTAlarmSeverity;
use app\util\SMTUtil;
use app\util\SMTRwDto;

/**
 * Base OTU system alarm Dto
 * 
 * @author Sylvain Desplat
 */
class SMTOtuAlarmDto extends SMTRwDto
{   
    /**
     * OTU severity
     * 
     * @var string
     */
    protected $severity;

    /**
     * Alarm creation date timestamp
     * 
     * @var integer
     */
    protected $date;
    
    /**
     * Alarm creation date as a string (not used just added to map info sent by OTU)
     * 
     * 
     * @var string
     */
    protected $dateHuman;
    
    /**
     * Alarm type (not used just added to map info sent by OTU)
     *
     *
     * @var string
     */
    protected $type;
    
    /**
     * Acknowledgment String to validate the processing of the alarm by SmartOtu in OTU if it is successful.
     * 
     * @var String
     */
    protected $acknowledge;

    /**
     * Event type code ( tOtu_Alarm_Event_Type; for example cET_equipmentAlarm )
     *
     * @var string
     */
    protected $alarmEventType;

    /**
     * Otu alarm version
     *
     * @var string
     */
    protected $version;
    
    /**
     * Otu alarm version
     *
     * @var string
     */
    public function getOtuAlarmVersion()
    {
    	return $this->version;
    }
    
    /**
     * Otu severity
     * 
     * @return string
     */
    public function getOtuSeverity()
    {
    	return $this->severity;
    }
    
    /**
     * SmartOtu Severity
     *
     * @return integer
     */
    public function getSeverityConvertedToSmartOtu()
    {
    	return SMTAlarmSeverity::fromOtuSeverityToSmartOtuSeverity( $this->severity );
    }
    
    /**
     *
     * @return string
     */
    public function getAcknowledgeString()
    {
    	return $this->acknowledge;
    }
    
    /**
     * Return otu alarm generation date in UTC
     * 
     * @param \SQLite3 $dbConnection
     * @return integer/float otu alarm generation date in UTC
     */
    public function getGenerationDateUTC( \SQLite3 $dbConnection )
    {   
    	return SMTUtil::getTimestampUTC( $this->date, $dbConnection );
    }    

    /**
     * Returns the event Type Code
     *
     * @return string
     */
    public function getEventTypeCode()
    {
    	return $this->alarmEventType;
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\alarm\otu\SMTOtuAlarmDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array, FALSE );
    }
}



?>