<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\alarm;

use app\util\SMTResultSetDto;

use app\util\SMTInvalidValueException;

/**
 * Optical alarm event Dto 
 * 
 * @author Sylvain Desplat
 * @SMTClassTableNameAnnotation(tablename='optical_alarm_event', tablekey='id') 
 */
abstract class SMTOpticalAlarmEventDto extends SMTAlarmEventDto
{        
    /**
     * deviation in dB
     * @var float
     */
    protected $firstMarkerDeviationDb = NULL;
    /**
     * deviation in dB
     * @var float
     */    
    protected $linkLossDeviationDb = NULL;    
    
    /**
     * Whether First marker deviation is valid
     * 
     * @var integer
     */
    protected $firstMarkerDeviationValid = SMTResultSetDto::BOOLEAN_VALUE_FALSE;
    
    /**
     * Whether Link loss deviation is valid
     * 
     * @var integer
     */
    protected $linkLossDeviationValid = SMTResultSetDto::BOOLEAN_VALUE_FALSE;

    /**
     * Whether the problem was confirmed by OTU
     *
     * @var integer
     */
    protected $problemConfirmed = SMTResultSetDto::BOOLEAN_VALUE_FALSE;     
    
    /**
     * Set whether the First marker deviation is valid
     *
     * @param boolean $valid
     */
    public function setFirstMarkerDeviationValid( $valid )
    {
    	$this->firstMarkerDeviationValid = SMTResultSetDto::fromBoolean( $valid );
    }
    
    /**
     * Returns whether the First marker deviation is valid
     *
     * @return boolean
     */
    public function isFirstMarkerDeviationValid()
    {
    	return SMTResultSetDto::ToBoolean( $this->firstMarkerDeviationValid );
    }
    
    /**
     * Set whether the link loss is valid
     *
     * @param boolean $valid
     */
    public function setLinkLossDeviationValid( $valid )
    {
    	$this->linkLossDeviationValid = SMTResultSetDto::fromBoolean( $valid );
    }
    
    /**
     * Returns whether the link loss is valid
     *
     * @return boolean
     */
    public function isLinkLossDeviationValid()
    {
    	return SMTResultSetDto::ToBoolean( $this->linkLossDeviationValid );
    }  
    
    /**
     * Set whether the problem was confirmed on OTU
     *
     * @param boolean $valid
     */
    public function setProblemConfirmed( $problemConfirmed )
    {
    	$this->problemConfirmed = SMTResultSetDto::fromBoolean( $problemConfirmed );
    }
    
    /**
     * Returns whether the problem was confirmed
     *
     * @return boolean
     */
    public function isProblemConfirmed()
    {
    	return SMTResultSetDto::ToBoolean($this->problemConfirmed );
    }
    
    /**
     * Set the deviation dB.
     * @param float $firstMarkerDeviationDb
     */
    public function setFirstMarkerDeviationDb( $firstMarkerDeviationDb )
    {
        if ( $firstMarkerDeviationDb !== NULL && !is_numeric( $firstMarkerDeviationDb ) )
        {
        	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "firstMarkerDeviationDb", $firstMarkerDeviationDb );
        }
        $this->firstMarkerDeviationDb = $firstMarkerDeviationDb;
    }
    /**
     * Returns the deviation in dB or NULL.
     * 
     * @return float
     */
    public function getFirstMarkerDeviationDb()
    {
        return $this->firstMarkerDeviationDb;
    }
    
    /**
     * Set the deviation in dB.
     * @param float $linkLossDeviationDb
     */
    public function setLinkLossDeviationDb( $linkLossDeviationDb )
    {
        if ( $linkLossDeviationDb !== NULL && !is_numeric( $linkLossDeviationDb ) )
        {
        	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "linkLossDeviationDb", $linkLossDeviationDb );
        }        
    	$this->linkLossDeviationDb = $linkLossDeviationDb;
    }
    /**
     * Returns the deviation in dB or NULL.
     *
     * @return float
     */
    public function getLinkLossDeviationDb()
    {
    	return $this->linkLossDeviationDb;
    }        
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
}



?>