<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\http;

/**
 * 
 * Custom session handler to manage a temporary directory by PHP sessions with temporary files.
 * That cutom directory is created on demand (not created when the session is initialized).
 * The removal is done when the session is destroyed or garbage collected.
 * 
 * @author Sylvain Desplat
 */
class SMTFileSessionHandler
{
    /**
     * PHP temporary session directory
     * @var string
     */
    private $savePath;

    function open($savePath, $sessionName)
    {
        $success = TRUE;
        $this->savePath = $savePath;
        if (!is_dir($this->savePath) ) 
        {
            $success = mkdir($this->savePath, 0777);
        }

        return $success;
    }

    function close()
    {
        return TRUE;
    }

    function read($id)
    {
        $filename = "$this->savePath/sess_$id";
        return file_exists($filename)? (string)@file_get_contents( $filename ) : "";
    }

    function write($id, $data)
    {
        return file_put_contents("$this->savePath/sess_$id", $data) === false ? false : true;
    }

    /**
     * Called by PHP framework:
     * clean up session file and custom smartOTU directory attach to the destroyed session.
     *
     * @param string $id
     * @return boolean
     */
    function destroy($id)
    {
        $success = TRUE;
        
        $file = "$this->savePath/sess_$id";
        if (file_exists($file)) 
        {
            $success = unlink($file);
        }
          
        SMTSessionDirectoryUtil::removeSessionDirectoryIfNeeded($id);
        
        return true;
    }

    /**
     * Function called by PHP garbage collector:
     * clean up expired session file and custom smartOTU directory attach to expired sessions. 
     * 
     * @param string $maxlifetime
     * @return boolean
     */
    function gc( $maxlifetime )
    {
        foreach ( glob("$this->savePath/sess_*") as $file ) 
        {
            if (file_exists($file) && ( filemtime($file) + $maxlifetime < time() ) ) 
            {
                unlink($file);
            }
        }
        
        SMTSessionDirectoryUtil::removeSessionsDirectoriesIfNeeded($maxlifetime);

        return true;
    }
}

?>