<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\events;

use app\events\operations\SMTIReplaceableEventDto;

use app\util\SMTIClonable;

use app\util\SMTRwDto;

/**
 * Base class for operation dto classes sent to the client application.
 * It serializes object properties as a json string.
 * 
 * @author Sylvain Desplat
 */
abstract class SMTEventDto extends SMTRwDto implements SMTIClonable, SMTIReplaceableEventDto
{
    /**
     * @var string
     */    
    protected $id;
        
    /**
     * should be called by wrapping function: getOperationId...
     * 
     * @return number 
     */
    function getId()
    {
        return $this->id;
    }
    
    /**
     * should be called by wrapping function: setOperationId...
     * 
     * @param number $id
     * 
     */
    function setId( $id )
    {
        $this->id = $id;
    }    
    
    /**
     * Whether the given event $eventDto can replace the current one
     * 
     * @param SMTIReplaceableEventDto $eventDto
     * @return boolean
     */
    function canReplace( SMTIReplaceableEventDto $eventDto)
    {
    	if ( $eventDto != NULL && $eventDto instanceof SMTEventDto )
    	{
    		return ( $this->getId() == $eventDto->getId() );
    	}
    	return FALSE;
    }
    
    /**
     * Update texts according to the current user langage.
     * By default, does nothing: must be overloaded in subclasses
     */
    function updateTranslations()
    {        
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }       
}

?>