<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright JDSU 2017. All rights reserved.
// *********************************************************
namespace app\database\patch;

use app\util\SMTLogger;

use app\database\SMTSmartOtuDB;

use app\database\SMTSqlPatch;

/**
 * Datatabase patch to add in peak optical alarms
 * Database version 1
 * Patch number 5
 *
 * @author Sylvain Desplat
 */
class SMTSql01p0005 extends SMTSqlPatch
{  
//patches:
	const SQL_CREATE_PEAK_OPTICAL_ALARM_EVENT =
	"CREATE TABLE IF NOT EXISTS peak_optical_alarm_event
     (
        id INTEGER NOT NULL PRIMARY KEY,
        reference_top_distance_m REAL DEFAULT 0,
        top_distance_m REAL DEFAULT 0,
        bottom_distance_m REAL DEFAULT 0,
        level_db REAL DEFAULT 0,
        level_valid INTEGER NOT NULL DEFAULT %b,
        peak_name TEXT,
        FOREIGN KEY(id) REFERENCES optical_alarm_event(id) ON DELETE CASCADE
     )";  
    
	static function getCreatePeakOpticalAlarmEventSql()
	{
		return sprintf( self::SQL_CREATE_PEAK_OPTICAL_ALARM_EVENT, FALSE );
	} 
    
    function __construct()
    {
        SMTLogger::getInstance()->trace( sprintf("Execute patch %s.", __CLASS__ ), SMTLogger::INFO );
        
    	//retrieve patch version
        $className = basename(__FILE__, '.php');
        preg_match_all('!\d+!', $className, $matches);
        
        $this->dbVersion = $matches[0][0];
        $this->dbPatch = $matches[0][1];    	
    }
    
    /**
     * @return SMTSql01p0005
     */    
    public static function getInstance()
    {
        return new SMTSql01p0005();
    }
    
    /**
     * Add smartOTU system_configuration table.
     *
     * @see \app\database\SMTSqlPatch::execute()
     */    
    public function execute( SMTSmartOtuDB $db )
    {    
    	$query = self::getCreatePeakOpticalAlarmEventSql();
    	$success = $db->execWithTrace($query, SMTLogger::INFO );
    	self::handleExecutePatchError($db, $query, $success, __FILE__, __METHOD__, __LINE__ ); 
    	
	    $success = $this->addPatchTrace($db, 'Add Peak alarms');
	    self::handleExecutePatchError($db, SMTSqlPatch::SQL_TRACE_DATABASE_PATCH, $success, __FILE__, __METHOD__, __LINE__ );    	
    }
}
?>