window.swaggerSpec={
  "swagger" : "2.0",
  "info" : {
    "title" : "ONMSi API for Bharti",
    "version" : "0.0.4",
    "description" : "This is the ONMSi API for Bharti integration with NetCool and FiberForce-1. All API calls require an API authentication key which will be set in properties file on the server."
  },
  "basePath" : "/bharti",
  "tags" : [ {
    "name" : "rfts",
    "description" : "Testing the fibre using RFTS tests"
  } ],
  "schemes" : [ "https", "http" ],
  "responses" : {
    "400" : {
      "description" : "Bad Request - the request could not be read - presumably not the proper JSON format"
    },
    "401" : {
      "description" : "Unauthorized - if API token header is missing or invalid"
    },
    "404" : {
      "description" : "Not Found - The requested object (link, alarm, ...) was found",
      "schema" : {
        "$ref" : "#/definitions/ErrorInfo"
      }
    },
    "502" : {
      "description" : "Bad Gateway - the request could not be completed by the underlying service (ONMSi) the *additionalCode* field of the returned ErrorInfo may include the HTTP status code returned by ONMSi.",
      "schema" : {
        "$ref" : "#/definitions/ErrorInfo"
      }
    }
  },
  "definitions" : {
    "TodRequest" : {
      "type" : "object",
      "description" : "TodRequest",
      "required" : [ "sectionId" ],
      "properties" : {
        "sectionId" : {
          "type" : "string",
          "description" : "Section short name (start and end M6 locations, as defined in ONMSi additional attribute of the *Link*)",
          "example" : "AAA-BBB"
        },
        "maxCount" : {
          "type" : "integer",
          "description" : "How many fibres will be checked max (if omitted it will be 1, if set to 0 then all fibres in the section will be tested - this is for the repair use case)",
          "example" : 4
        }
      }
    },
    "TodResponse" : {
      "type" : "object",
      "description" : "TodResponse",
      "required" : [ "operationId" ],
      "properties" : {
        "operationId" : {
          "type" : "integer",
          "description" : "The operation ID which will be used for later communication",
          "example" : 1234
        },
        "startedTests" : {
          "type" : "integer",
          "description" : "How many tests were started as a result of the request. Will be > 0 as in case no test was found, the request returns an HTTP 404 status.",
          "example" : 1
        }
      }
    },
    "UpdateAlarmTicketRequest" : {
      "type" : "object",
      "description" : "AckRequest",
      "properties" : {
        "troubleTicketNumber" : {
          "type" : "string",
          "description" : "The trouble ticket to associate to this alarm",
          "example" : 54321
        },
        "liveFiberTroubleTicketNumber" : {
          "type" : "string",
          "description" : "The trouble ticket to associate to this alarm",
          "example" : 54321
        }
      }
    },
    "ErrorInfo" : {
      "type" : "object",
      "required" : [ "message" ],
      "properties" : {
        "message" : {
          "type" : "string",
          "description" : "The detailed error message",
          "example" : "Could not connect to ONMSi"
        },
        "additionalCode" : {
          "type" : "integer",
          "description" : "An (optional) code in addition to the HTTP status",
          "example" : 502
        }
      }
    }
  },
  "security" : [ {
    "apiKeyHeader" : [ ]
  } ],
  "paths" : {
    "/api/startTest" : {
      "post" : {
        "tags" : [ "rfts" ],
        "summary" : "Execute a series of tests on demand on a given section.",
        "operationId" : "executeTestOnDemand",
        "description" : "Executes a series of test on demand for some or all fibres matching the section ID (which is the concatenation of the two M6-locations of the start and the end of the section. That ID should exactly match the additional attributes set on  the corresponding *links* within ONMSi.",
        "consumes" : [ "application/json", "application/xml" ],
        "produces" : [ "application/json", "application/xml" ],
        "parameters" : [ {
          "in" : "body",
          "name" : "todRequest",
          "description" : "The TOD request",
          "required" : true,
          "schema" : {
            "$ref" : "#/definitions/TodRequest"
          }
        } ],
        "responses" : {
          "200" : {
            "description" : "OK - Test request was recorded. Status will be provided asynchronously by SNMP traps",
            "schema" : {
              "$ref" : "#/definitions/TodResponse"
            }
          },
          "400" : "err_400",
          "401" : "err_401",
          "404" : "err_404",
          "502" : "err_502"
        }
      }
    },
    "/api/alarms/{alarmId}/acknowledge" : {
      "post" : {
        "tags" : [ "rfts" ],
        "summary" : "Acknowledge an alarm",
        "operationId" : "acknowledgeAlarm",
        "description" : "Acknowledges an alarm given its alarm ID. The alarm ID as displayed by ONMSi or as sent in the SNMP jdsuOnmsiBhartiAlarmId",
        "produces" : [ "application/json", "application/xml" ],
        "parameters" : [ {
          "in" : "path",
          "name" : "alarmId",
          "description" : "The ID of the alarm to acknowledge",
          "required" : true,
          "type" : "integer",
          "format" : "int64"
        } ],
        "responses" : {
          "204" : {
            "description" : "No Content - Alarm was acknowledged"
          },
          "400" : "err_400",
          "401" : "err_401",
          "404" : "err_404",
          "502" : "err_502"
        }
      }
    },
    "/api/alarms/resynchronize" : {
      "post" : {
        "tags" : [ "rfts" ],
        "summary" : "Resynchronize alarms",
        "operationId" : "resynchronizeAlarms",
        "description" : "Resynchronize alarms from an alarm sequence. An empty \"from\" query parameter  will perform a full resynchronization.",
        "produces" : [ "application/json", "application/xml" ],
        "parameters" : [ {
          "in" : "query",
          "name" : "from",
          "description" : "The alarm sequence of the first missing alarm. Leave empty for full resynchronization.",
          "required" : false,
          "type" : "integer",
          "format" : "int64"
        } ],
        "responses" : {
          "204" : {
            "description" : "No Content - Resynchronization started"
          },
          "400" : "err_400",
          "401" : "err_401",
          "404" : "err_404",
          "502" : "err_502"
        }
      }
    },
    "/api/alarms/{alarmId}/ticket" : {
      "put" : {
        "tags" : [ "rfts" ],
        "summary" : "Updates the TT in an alarm",
        "operationId" : "updateAlarmTicketNumber",
        "description" : "Updates the TT (trouble ticket) number in the alarm given its ID. The alarm ID as displayed by ONMSi or as sent in the SNMP jdsuOnmsiBhartiAlarmId",
        "consumes" : [ "application/json", "application/xml" ],
        "produces" : [ "application/json", "application/xml" ],
        "parameters" : [ {
          "in" : "path",
          "name" : "alarmId",
          "description" : "The ID of the alarm to update",
          "required" : true,
          "type" : "integer",
          "format" : "int64"
        }, {
          "in" : "body",
          "name" : "updateAlarmTicketRequest",
          "description" : "The update request",
          "required" : true,
          "schema" : {
            "$ref" : "#/definitions/UpdateAlarmTicketRequest"
          }
        } ],
        "responses" : {
          "204" : {
            "description" : "No Content - Alarm was TT was updated"
          },
          "400" : "err_400",
          "401" : "err_401",
          "404" : "err_404",
          "502" : "err_502"
        }
      }
    }
  },
  "securityDefinitions" : {
    "apiKeyHeader" : {
      "type" : "apiKey",
      "name" : "x-api-key",
      "in" : "header"
    }
  }
}