import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    width: 80
    height: parent.height

    color: isSelected ? VColor.cViaviColorMediumBlue : VColor.cViaviColorLightBlue
    opacity: isEnabled ? 1 : 0.4

    Text {
        text: name
        color: VColor.cViaviColorWhite
        font.pixelSize: isSelected ? 20 : 16
        font.bold: isSelected
        clip: true
        anchors.fill: parent
        wrapMode: Text.WordWrap
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignHCenter
    }

    MouseArea {
        anchors.fill: parent
        enabled: isEnabled
        onClicked: {
           selectValueChanged( index );
        }
    }
}
