<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\view;

use app\http\SMTSessionDirectoryUtil;
use app\serviceshelper\otdr\SMTOtdrTraceFileUtil;
use app\util\SMTIOException;

/**
 * Flush the otdr trace buffer for the given otdr trace file name.
 *
 * @author Sylvain Desplat
 */
class SMTOtdrTraceFileDownloadPage implements SMTIPage
{
	private $FILES_ALLOWED_FOR_DOWNLOAD = array('sor','csor','msor');
	private $DIRECTORIES_ALLOWED_FOR_DOWNLOAD = array(SMTSessionDirectoryUtil::CUSTOM_SMARTOTU_SESSION_DIR, SMTOtdrTraceFileUtil::OTU_TEST_RESULT_DET_DIR, SMTOtdrTraceFileUtil::OTU_TEST_RESULT_LOC_DIR, SMTOtdrTraceFileUtil::OTU_MEASURE_ON_DEMAND_DIR,SMTOtdrTraceFileUtil::OTU_MEASURE_REF_DET_DIR, SMTOtdrTraceFileUtil::OTU_MEASURE_REF_LOC_DIR, SMTOtdrTraceFileUtil::CUSTOM_SMARTOTU_ALARM_DIR,SMTOtdrTraceFileUtil::OTU_RESULT_DET_DIR, SMTOtdrTraceFileUtil::OTU_RESULT_LOC_DIR);
	
	private $otdrTracefileName;
	private $otdrTraceType;
	
	/**
	 * Construct the builder of otdr trace file.
	 * 
	 * @param string $otdrTracefileName
	 * @param string $otdrTraceType SMTOtdrTraceType::OTU_REFERENCE_TRACE, SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE, SMTOtdrTraceType::LAST_TEST_ACQUISITION_TRACE
	 * 
	 */
	function __construct( $otdrTracefileName, $otdrTraceType )
	{
		$this->otdrTracefileName = $otdrTracefileName;
		$this->otdrTraceType = $otdrTraceType;
	}
	
	/**
	 * Only a few type of files are allowed to be downloaded
	 *
	 * @param string $fileName
	 * @return boolean
	 */
	function checkFileExtension($fileName)
	{
		$ext = pathinfo($fileName, PATHINFO_EXTENSION);
		return in_array($ext, $this->FILES_ALLOWED_FOR_DOWNLOAD);
	}
	
	/**
	 * Only a few directories are allowed for download
	 *
	 * @param string $fileName
	 * @return boolean
	 */
	function checkDirectory($fileName)
	{
		$dir = pathinfo($fileName, PATHINFO_DIRNAME).'/';
// 		SMTLogger::getInstance()->trace($dir);
		return in_array($dir, $this->DIRECTORIES_ALLOWED_FOR_DOWNLOAD) || (strpos($dir, SMTSessionDirectoryUtil::CUSTOM_SMARTOTU_SESSION_DIR) !== false);
	}

	/**
	 * Flush the otdr trace buffer for the given otdr trace file name
	 *
	 */
	function generatePage()
	{	    
	    //test file exists:
		if( $this->checkFileExtension($this->otdrTracefileName) && $this->checkDirectory($this->otdrTracefileName) && ($handle = fopen($this->otdrTracefileName ,"rb")) != FALSE )
        {            
        	//open buffering
         	header('Content-Type: application/octet-stream;');
         	header('Content-Disposition: attachment; filename="'.basename( $this->otdrTracefileName ).'";');
         	header('Cache-Control: no-cache, must-revalidate');
         	header('Expires: 0');         	
        	ob_start();            
            while ( !feof($handle) ) 
            {
                echo fread($handle , 8192 );
            }            
            fclose($handle);     

            //end buffering and flush
            return ob_end_flush();
        }        
        else
        {
        	throw new SMTIOException( SMTIOException::FILE_NOT_FOUND, rawurlencode(basename($this->otdrTracefileName)) );
        }        
	}
}
?>