<?php
namespace app\util\upload;
/**
 * include autoloader
 */
require_once('SMTUpload.php');

use app\util\SMTLogger;
use app\services\maintenance\SMTUploadStatusDto;
use app\serviceshelper\monitoring\SMTGpsRoute;
use app\util\upload\SMTUploadStatus;

/**
 * Begining of upload script
 * 
 */
//2mn script timeout
set_time_limit(120);
$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( $noUploadRunning == TRUE )
{
    //save kml in the target dir = same dir as gps segment file
    $uploadStatus = upload_file( SMTGpsRoute::GPS_ROUTE_DIR, 'checkKml' );    
    
    if ( $uploadStatus->getUploadErrorStatus() == SMTUploadStatusDto::NO_ERROR )
    {
        SMTLogger::getInstance()->trace("Upload kml complete: ".$uploadStatus->getFileName(), SMTLogger::INFO );
    }    
}
else
{
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
    SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
    
    // add error code 401 in case of upload failure
    @header('Cache-Control: no-cache, must-revalidate', true, 401 ); 
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>