<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2014. All rights reserved.
// *********************************************************
namespace app\util;

/**
 * Concurrent Access exceptions
 * 
 * @author Sylvain Desplat
 *
 */
class SMTConnectionException extends SMTException
{       
    const CONNECTION_FAILED = "CONNECTION_FAILED";
    const SAA_CONNECTION_FAILED = "SAA_CONNECTION_FAILED";
    
    /**
     *
     * @param string $code error code
     * @param string $message detailed message
     */    
    function __construct( $code = NULL, $message = NULL )
    {
    	parent::__construct( $code, $message );
    }
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
        
    /**
     * Translates status code. If the code is not found, returns an empty string.
     *
     * @param string $code The status code to translate
     *
     * @return string the status message or an empty string if the status couldn't be found.
     */
    public function decodeMessage( $code )
    {
    	$message = MSG_ERROR_CONNECTION_FAILED.$code;
    
    	switch( $code )
    	{
    	    case self::SAA_CONNECTION_FAILED:
    	    	$message = MSG_ERROR_SAA_CONNECTION_FAILED;
    	    	break; 	    	
    	    	
	    	default:
	    		break;
    	}
    	return $message;
    }
}

?>