<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\otdr;

use app\util\SMTInvalidValueException;

use app\util\SMTUtil;

use app\util\SMTDto;

/**
 * 
 * @author Sylvain Desplat
 *
 */
class SMTOtdrPulseDto extends SMTDto
{
    /**
     * @var number
     */
    protected $pulseNs = 0;
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\serviceshelper\otdr\SMTOtdrRangeDto',islist='true')
     * @var app\serviceshelper\otdr\SMTOtdrRangeDto[]
     */
    protected $otdrRangeArray = array();    
    
    /**
     * @param int $pulseNs
     */
    public function setPulseNs( $pulseNs )
    {
        if ( !isset($pulseNs) || $pulseNs === NULL || !SMTUtil::isInt( $pulseNs ) )
        {
        	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "pulseNs", $pulseNs );
        }
        
    	$this->pulseNs = intval($pulseNs);
    }
    
    /**
     * @return int
     */
    public function getPulseNs()
    {
        return $this->pulseNs !== NULL ? intval($this->pulseNs) : NULL;
    }    
    
	/**
	 * @param app\serviceshelper\otdr\SMTOtdrRangeDto[]
	 */
	public function setOtdrRangeArray( $otdrRangeArray)
	{
		$this->otdrRangeArray = $otdrRangeArray;
	}

	/**
	 * @return app\serviceshelper\otdr\SMTOtdrRangeDto[]
	 */
	public function getOtdrRangeArray()
	{
		return $this->otdrRangeArray;
	}

	/**
	 * @param app\serviceshelper\otdr\SMTOtdrRangeDto
	 */
	public function addOtdrRange( SMTOtdrRangeDto $otdrRange )
	{
		array_push( $this->otdrRangeArray, $otdrRange );
	}	
	
	/**
	 * 
	 * @param app\serviceshelper\otdr\SMTOtdrPulseDto $otdrPulse
	 * 
	 * @return boolean
	 */	
	public function compare( $otdrPulse )
	{
	    return $this->pulseNs == $otdrPulse->pulseNs;
	}
	
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}
?>