<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTInvalidValueException;

use app\util\SMTUtil;

use app\http\SMTISerializable;

use app\util\SMTRwDto;

/**
 * Dto with OTU internal switch infos
 * 
 * @author Sylvain Desplat
 */
class SMTSwitchDto extends SMTRwDto implements SMTISerializable
{
    /**
     * Switch index: 0 pour interne, 31 pour OSX distributeur...
     */
    protected $index = 0; //internal switch by default
    /**
     * @var number
     */
	protected $input;
	/**
	 * @var number
	 */	
	protected $output;
	/**
	 * 
	 * @var string
	 */
	protected $serialNumber;
	/**
	 * 
	 * @var boolean
	 */
	protected $detected = false;
	/**
	 * 
	 * @var string
	 */
	protected $globalSwitchEncodedString = NULL;

	public function setIndex( $index )
	{
		$this->index = $index;
	}
	
	public function setDetected( $detected )
	{
		$this->detected = $detected;
	}
	
	public function setInput( $input )
	{
	    if ( !isset($input) || $input === NULL || !SMTUtil::isInt( $input ) )
	    {
	    	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "switch input", $input );
	    }
		$this->input = intval($input);
	}
	
	public function setOutput( $output )
	{
	    if ( !isset($output) || $output === NULL || !SMTUtil::isInt( $output ) )
	    {
	    	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "switch output", $output );
	    }	    
		$this->output = intval($output);
	}
	
	public function setSerialNumber( $serialNumber )
	{
		$this->serialNumber = $serialNumber;
	}
	
	public function isDetected()
	{
		return $this->detected;
	}

	public function setGlobalSwitchEncodedString( $globalSwitchString )
	{
		$this->globalSwitchEncodedString = $globalSwitchString;
	}
	
	public function getGlobalSwitchEncodedString()
	{
		return $this->globalSwitchEncodedString;
	}	
	
	public function getInput()
	{
	    return $this->input;
	}
	
	public function getOutput()
	{
	    return $this->output;
	}
	
	public function getSerialNumber()
	{
		return $this->serialNumber;
	}
	
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\setup\SMTSwitchDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }
    
    /**
     * Serialize object stored in session
     *
     * @return multitype:string
     */
    public function __sleep()
    {
    	return $this->getSerializableProperties();
    }
    
    /**
     * Returns the serializable properties of the object.
     *
     * @see \app\http\SMTISerializable::getSerializableProperties()
     */
    public function getSerializableProperties()
    {
    	$objectProperties = get_object_vars($this);
    	return array_keys( $objectProperties );
    }
    
    /**
     * Deserialize object.
     */
    public function __wakeup()
    {
    }    
}
?>