<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\monitoring;

use app\util\SMTUtil;

use app\util\SMTDto;

/**
 * Handles OTU current port when OTU is used with an external switch managed by an external application
 * 
 * @author Sylvain Desplat
 */
class SMTCurrentPortDto extends SMTDto
{       
    /**
     * no current port selected: if a port is selected, deselect it
     * 
     * @var integer
     */
    const NO_PORT_SELECTED = -1;
    
    /**
     * no current port value
     *
     * @var integer
     */
    const INVALID_CURRENT_PORT = -2;

    /**
     * virtual switch count not set: ignore the given port count
     *
     * @var integer
     */
    const INVALID_VIRTUAL_SWITCH_COUNT = -1;   
    
    /**
     * 
     * @var integer OTU current port when used with external switch managed by external application
     */
    protected $currentPort = self::NO_PORT_SELECTED;
	
	/**
	 * Virtual switch port count used when an external switch not managed by OTU is used
	 *
	 * @var int
	 */
	protected $virtualSwitchPortCount = self::INVALID_VIRTUAL_SWITCH_COUNT;
	
	/**
	 * @param string $releaseVersion
	 */
	public function setCurrentPort( $currentPort )
	{
	    if ( self::isValid($currentPort) )
	    {
	    	$this->currentPort = intval($currentPort);
	    }	    
	    else
	    {
	    	$this->currentPort = self::NO_PORT_SELECTED;
	    }	    
	}
	
	/**
	 *
	 * @param int $virtualSwitchPortCount
	 */
	public function setVirtualSwitchPortCount( $virtualSwitchPortCount )
	{
		if ( isset($virtualSwitchPortCount) && $virtualSwitchPortCount !== NULL || SMTUtil::isInt( $virtualSwitchPortCount ) )
		{
			$this->virtualSwitchPortCount = intval($virtualSwitchPortCount);
		}
	}
	
	
	/**
	 * Whether the value is a valid number
	 *
	 * @param string $value
	 * @return boolean
	 */
	public static function isValid( $value )
	{
		if ( SMTUtil::isInt( $value ) && ($value > 0) )
		{
			return TRUE;
		}
		return FALSE;
	}	

	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}    
}


?>