<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\alarm\otu;

use app\util\SMTUtil;

use app\serviceshelper\alarm\SMTAlarmSpecificProblemCode;

/**
 * Base OTU system alarm Dto
 * 
 * @author Sylvain Desplat
 */
class SMTOtuSystemAlarmDto extends SMTOtuAlarmDto
{   
    /**
     * Alarm specific problem addition information (used as a composite key in OTU system alarms)
     * 
     * @var string
     */
    protected $info;

    /**
     * Specific problem Id in OTU ( tOtu_Alarm_Label; for example cOtu_Alarm_Local_Mode ); cf. SMTAlarmSpecificProblemCode.php
     * (used as a composite key in OTU system alarms)
     *
     * @var integer
     */
    protected $specificId;
    
    /**
     * Specific problem Code cf. SMTAlarmSpecificProblemCode.php
     * 
     * @var string
     */
    protected $specific;

    
    /**
     * Returns the specific problem Code
     * 
     * @return integer
     */
    public function getSpecificProblemCode()
    {
    	return $this->specific;
    } 
    
    /**
     * Returns the specific problem Id in OTU
     *
     * @return number
     */
    public function getSpecificProblemId()
    {
    	return SMTUtil::convertToInt( $this->specificId );
    }
    
    /**
     * Returns the specific problem additional info
     * @return string
     */
    public function getAdditionalInfo()
    {
    	return $this->info;
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\alarm\otu\SMTOtuSystemAlarmDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array, FALSE );
    }
}



?>