<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\admin;

use app\util\SMTRwDto;
/**
 * Dto to update password of the given user
 * 
 * @author sdesplat
 */
class SMTChangeUserPasswordDto extends SMTRwDto
{   
    /**
     * 
     * @var string
     */
    protected $login;
    
    /**
     *
     * @var string
     */    
    protected $newLogin;
    
    /**
     *
     * @var string
     */    
    protected $oldPassword;

    /**
     *
     * @var string
     */    
    protected $newPassword;
        
    /**
     *
     * @var string
     */
    protected $confirmationPassword;
    
    /**
     *
     * @return string
     */
    public function getLogin()
    {
    	return $this->login;
    }    
    
    /**
     *
     * @return string
     */
    public function getNewLogin()
    {
    	return $this->newLogin;
    }
    
    /**
     *
     * @return string
     */
    public function getOldPassword()
    {
    	return $this->oldPassword;
    }

    /**
     *
     * @return string
     */
    public function getNewPassword()
    {
    	return $this->newPassword;
    }

    /**
     *
     * @return string
     */
    public function getConfirmationPassword()
    {
    	return $this->confirmationPassword;
    }    
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\admin\SMTChangeUserPasswordDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }   
    
    /**
     * Serialize as Json data the user object.<br> 
     * 
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
        $this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }    
}

?>