<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app;

use app\services\SMTIService;

use app\settings\SMTSmartOtuSettings;

use app\util\SMTUtil;

use app\util\SMTLogger;

use Luracast\Restler\AutoLoader;
use Luracast\Restler\Defaults;
use app\http\SMTContext;

/**
 * REST request controller: 
 * initializes REST Restler router and map REST requests to services. 
 * 
 * @author sdesplat
 */
class SMTController 
{
    /**
     * Array of services with their associated class names
     * 
     * @var Array
     */
     private static $service_class_names = Array(
             SMTIService::SECURITY_SERVICE=>'SMTSecurityService',
             SMTIService::ETHERNET_SERVICE=>'SMTEthernetService',
             SMTIService::MODULE_SERVICE=>'SMTModuleService',
             SMTIService::SWITCH_SERVICE=>'SMTSwitchService',
             SMTIService::EMAIL_SERVICE=>'SMTEmailService',
             SMTIService::SMS_SERVICE=>'SMTSmsService',
             SMTIService::SNMP_SERVICE=>'SMTSnmpService',
     		 SMTIService::ONMSI_SERVICE=>'SMTOnmsiServerService',     		
             SMTIService::WEB_SERVICE=>'SMTWebServiceService',
             SMTIService::LINK_TEST_SERVICE=>'SMTLinkTestService',
             SMTIService::MESSAGE_SERVICE=>'SMTMessageService',
             SMTIService::OTDR_ACQ_SERVICE=>'SMTOtdrAcqService',
             SMTIService::ALARM_SERVICE=>'SMTAlarmService',
             SMTIService::SMART_OTU_SETTINGS_SERVICE=>'SMTSmartOtuSettingsService',
             SMTIService::ACTIVITY_SERVICE=>'SMTActivityService',
             SMTIService::AUTOTEST_SERVICE=>'SMTAutotestService',
             SMTIService::MAINTENANCE_SERVICE=>'SMTMaintenanceService'
             );    
    
     const ACCESS_CONTROL_CLASS = 'SMTAccessControl';
     const FRAMEWORK_ACCESS_CONTROL_CLASS = 'Resources';
     
    /**
     * Application context
     * 
     * @var SMTContext
     */
	protected $context;
	
	/**
	 * Request router
	 * 
	 * @var SMTRestlerRouter
	 */
	protected $router;
	
	/**
	 * 
	 * @param SMTContext $context
	 */
	public function __construct( SMTContext $context )
	{
		$this->context = $context;			
	}
			
	/**
	 * Init the router routing REST requests to their service.
	 * 
	 */
	public function initRouter()
	{
	    //By default access level for api is 0:
	    //and control api access using `@access protected` comment;
	    Defaults::setProperty('apiAccessLevel', 0);	    
		//Defaults::setProperty('apiAccessLevel', 2);		
		
	    //declare APIs paths
	    $servicePath = __DIR__.'/services/';
		AutoLoader::addPath($servicePath.'security/');
		AutoLoader::addPath($servicePath.'setup/');
		AutoLoader::addPath($servicePath.'monitoring/');
		AutoLoader::addPath($servicePath.'otdr/');
		AutoLoader::addPath($servicePath.'message/');
		AutoLoader::addPath($servicePath.'alarm/');
		AutoLoader::addPath($servicePath.'activity/');
		AutoLoader::addPath($servicePath.'autotest/');
		AutoLoader::addPath($servicePath.'maintenance/');		

		//init the framework router 
		if ( SMTSmartOtuSettings::isDebugMode() )
		{
		    //parse the services classes file every time
		    $this->router = new SMTRestlerRouter( $this->context, FALSE, FALSE);
		}
		else
		{
		    //production mode
		    $this->router = new SMTRestlerRouter( $this->context, TRUE, FALSE);
		}
		$this->router->setSupportedFormats('JsonFormat');							
		$this->router->loadRoutes( static::$service_class_names );		
		
		$this->router->addAuthenticationClass( self::ACCESS_CONTROL_CLASS );
	}
	
	/**
	 * Launch the router
	 * 
	 */
	public function runRouter()
	{	    	    	    
	    $this->context->getLogger()->trace( sprintf( "SMTController %s request: %s", $_SERVER["REQUEST_METHOD"], $_SERVER["REQUEST_URI"] ) );
	    
	    if ( SMTLogger::isDebugLogLevel() )
	    {
    	    if ( $_SERVER["REQUEST_METHOD"] == "POST" && count ( $this->router->getRequestData() ) > 0 )
    	    {
    	        $this->context->getLogger()->trace( sprintf( "SMTController POST data: %s", SMTUtil::serialize_array( $this->router->getRequestData() ) ),SMTLogger::DEBUG, __FILE__,__METHOD__,__LINE__ );
    	    }
    	    else if ( $_SERVER["REQUEST_METHOD"] == "GET" && count ( $_GET ) > 0)
    	    {
    	    	$this->context->getLogger()->trace( sprintf( "SMTController GET data: %s", SMTUtil::serialize_array( $_GET ) ),SMTLogger::DEBUG, __FILE__,__METHOD__,__LINE__ );
    	    }
    	    else if ( $_SERVER["REQUEST_METHOD"] == "PUT" && count( $this->router->getRequestData() ) > 0 )
    	    {
    	    	$this->context->getLogger()->trace( sprintf( "SMTController PUT data: %s", SMTUtil::serialize_array( $this->router->getRequestData() ) ),SMTLogger::DEBUG, __FILE__,__METHOD__,__LINE__ );
    	    }
    	    else if ( $_SERVER["REQUEST_METHOD"] == "DELETE" && count( $this->router->getRequestData() ) > 0  )
    	    {
    	    	$this->context->getLogger()->trace( sprintf( "SMTController DELETE data: %s", SMTUtil::serialize_array( $this->router->getRequestData() ) ),SMTLogger::DEBUG, __FILE__,__METHOD__,__LINE__ );
    	    }
	    }
	     	    
	    //execute request
	    $result = $this->router->handle();
	}		
	
	public function __destruct()
	{
		$this->router = null;
		$this->context = null;
	}
	
// 	/**
// 	 * Build service url from class name: SMTSecurityService -> security
// 	 * 
// 	 * @param string $className
// 	 * 
// 	 * @return string service name
// 	 */
// 	private static function buildServiceNameFromURL( $className )
// 	{	    
//         preg_match('#SMT(.+)Service#i', $className, $matches);	    
// 	    return strtolower( $matches[1] );
// 	}
	
}
?>