<?php
require_once 'app/SMTApplication.php';
require_once 'app/view/SMTAppPage.php';
require_once 'app/admin/SMTUserUtil.php';
require_once 'app/http/SMTSession.php';

ob_start();
//echo('<!DOCTYPE html>');

$errorLoginMessage = NULL;
$app = NULL;
$notLoggedIn = FALSE;

try 
{
    //restore application context
    $app = new app\SMTApplication;
    $app->init(FALSE);
    
    //call hasValidLoginToken even if user is already logged-in to clean up the token in the login token file even if it is not used
    $validLoginToken =  $app->getContext()->getHttpRequest()->hasValidLoginToken( $app->getContext() );
    
    $user = $app->getContext()->getUser();
    if ( isset( $user ) && $user instanceof app\admin\SMTUserDto )
    {
        //we are logged in
        $notLoggedIn = FALSE;
    }    
    else
    {         
    	//try to login directly from http request header if the user is not already logged in
     	if ( $validLoginToken )
     	{
     	    //Restore PHP session context: PHP session context must be restored to handle session time-out and user identifiers.
     	    $session =  $app->getContext()->getSessionContext( FALSE );
     	    $user = app\admin\SMTUserDto::forgeUser( app\admin\SMTUserUtil::getSmartOtuUnixLogin(), app\admin\SMTRoleDto::INSTALL );
     	    $session->setUser($user);
     	    $notLoggedIn = FALSE;    	    	
     	}
     	else
     	{
         	//try to login directly from http request header if the user is not already logged in
        	$userIdentifiers = $app->getContext()->getHttpRequest()->decodeUserAuthorizationFromHeader();
        	if ( $userIdentifiers != null )
        	{
        		//test if user exists
        		$user = app\admin\SMTUserUtil::authenticate($app->getContext(), $userIdentifiers[0], "", base64_encode($userIdentifiers[1]) );
        		
        		//Restore PHP session context: PHP session context must be restored to handle session time-out and user identifiers.
        		$session =  $app->getContext()->getSessionContext( FALSE );
        		$session->setUser($user);
        		$notLoggedIn = FALSE;
        	}
        	else
        	{
                $notLoggedIn = TRUE;
        	}
     	}
    }
    
    if ( !$notLoggedIn )
    {
        //we are logged in, load main GWT hostpage
        $page = new app\view\SMTAppPage( $app->getContext() );
        $app->getContext()->getHttpResponse()->send( $page );
    }
    
}
catch( \Exception $e)
{
    $notLoggedIn = TRUE;
    $errorLoginMessage= $e->getMessage();   
}

//in case of error, go back to login page
if ( $notLoggedIn )
{
    $page = new app\view\SMTRedirectLoginPage( $app->getContext() );
    $app->getContext()->getHttpResponse()->send( $page, FALSE );
    //reset session variables
    $app->getContext()->closeSession();
}

ob_end_flush();
?>
