#!/bin/sh

usage () {
        echo "usage:  $0 user_name password"
        exit 1
}

success=1
IN=

if [ ! -z "$1" -a ! -z "$2" ]
then
#    echo "user_name: $1"
#    echo "password: $2"

    if [ -s "/etc/shadow" ]; then
       IN=`cat /etc/shadow | grep "$1"`
    else
       IN=`cat /etc/passwd | grep "$1"`
    fi
else
    usage
fi

#echo "found: $IN"
if [ ! -z "$IN" ]
then
    IFS=':' read -ra password_enc <<< "$IN"
    echo ${password_enc[1]}
    IFS='$' read -ra password_arr <<< "${password_enc[1]}"
    echo "algo: ${password_arr[1]}"
    echo "salt: ${password_arr[2]}"
    encoded_password=`openssl passwd -${password_arr[1]} -salt ${password_arr[2]} "$2"`
    echo $encoded_password
    [ "${password_enc[1]}" == "$encoded_password" ] && success=0
fi

echo "result: $success"

exit $success
