#!/bin/bash
# File to source to know otu disk partitions
#
#	Define the following variable :
#	 - DEV_SDCARD Block device for the SD card (extra memory for Otu)
#	 - DEV_USER   Name of hardisk partition
#	 - DEV_LOG    Name of the log partition
#	 - CURRENT_PART Name of the current root FS partition
#	 - ALT_PART	  Name of the secondary FS partition
#

DEV_SDSCARD="/dev/mmcblk0"
DEV_USER="${DEV_SDSCARD}p3"
DEV_SYST="${DEV_SDSCARD}p2"
DEV_LOG="${DEV_SDSCARD}p1"

#
# Manage other part mount point and location
CURRENT_PART=5
for argument in $(cat /proc/cmdline)
do
    if [[ $argument == root=* ]]
    then
        CURRENT_PART=$(echo $argument | cut -d '=' -f 2)
    fi
done
ALT_PART="/dev/mmcblk1p5"
[ "$CURRENT_PART" == "/dev/mmcblk1p5" ] && ALT_PART="/dev/mmcblk1p6"

