import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    id: container
    color: "lightgrey"

    width: 320
    height: 410

    radius: 5

    border.width: 3
    border.color: "darkgrey"

    // 'Public' properties
    property string titleText: ""
    property string initialText: ""

    property string entertext:"\u23CE"
    property string cancelText: "\u00D7"
    property int slider_width: 5

    property int labelHeight: 30
    property int txtSize: 18
    property int columnSpacing: 5
    property int lineSpacing: 8
    property int buttonWidth: 58

    property string label: "Please select alarm below"

    // Signals
    signal btnOkClicked(int index);
    signal btnCancelClicked();

    onBtnOkClicked: {
        close()
    }

    onBtnCancelClicked: {
        close()
    }

    function close() {
        container.visible = false
    }
    
    function addText(text) {
    
    }

    property int current_idx_selected : 0
    property alias model_list : list.model

    Column {
        width: parent.width
        height: parent.height
        anchors.rightMargin: lineSpacing
        anchors.right: parent.right
        anchors.leftMargin: lineSpacing
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.topMargin: lineSpacing
        spacing: lineSpacing

        Rectangle  {
            id: titleKeyBoard
            width: parent.width
            height: labelHeight
            color: "transparent"

            Text {
                id: txtTitleKeyboard
                text: label
                anchors.topMargin: 8
                anchors.fill: parent
                font.pixelSize: txtSize
                horizontalAlignment: Text.AlignHCenter
                clip: true
            }
        }

        Rectangle
        {
            id: parentlist
            width: parent.width
            height: parent.height - sectionExit.height - 4 * lineSpacing - titleKeyBoard.height
            color: VColor.cViaviColorWhite
            radius: 5

            ListView {
                id: list
                anchors.left: parent.left
                anchors.right: parent.right
     			    anchors.rightMargin: verticalSlider.width +  2 * 5
     			    anchors.top: parent.top
     			    anchors.topMargin: lineSpacing 
     			    anchors.bottom: parent.bottom
     			    anchors.bottomMargin: lineSpacing 
                
                spacing:lineSpacing
                boundsBehavior: Flickable.StopAtBounds
                
                currentIndex: current_idx_selected

                highlight: Rectangle { width: list.width; color: VColor.cViaviColorMediumBlue; }
                highlightFollowsCurrentItem: true

                highlightMoveSpeed: -1
                highlightMoveDuration: -1

                clip:true
                
                onVisibleChanged: focus = visible;  
                
		onCurrentIndexChanged: {
		  current_idx_selected = currentIndex;
		}
                
                onContentYChanged: {
                    verticalSlider.ratio = (parentlist.height * 100 ) / ( list.contentHeight + 2 * lineSpacing )
                    verticalSlider.value = parseInt(contentY, 10) * 100 / list.contentHeight;
                }

                onContentHeightChanged: {
                    verticalSlider.ratio = (parentlist.height * 100 ) / ( list.contentHeight + 2 * lineSpacing )
                }
                
                onHeightChanged: verticalSlider.ratio = (parentlist.height * 100 ) / (list.contentHeight + 2 * lineSpacing);
                                             
                contentY: parseInt(verticalSlider.value * list.contentHeight / 100 , 10)
        		
                model: model_list
                delegate:
                    Text {
                    id: h;

                    width: parent.width
                    height: labelHeight
                    anchors.left : parent.left
                    anchors.leftMargin: h.ListView.isCurrentItem ? slider_width : lineSpacing
                    text: modelData
                    verticalAlignment: Text.AlignVCenter
                    font.pixelSize: h.ListView.isCurrentItem ? 25 : 20
                    font.bold: h.ListView.isCurrentItem

                    color: h.ListView.isCurrentItem ? VColor.cViaviColorWhite : VColor.cViaviColorBlack

                    MouseArea {
                        anchors.fill: parent
                        onClicked: {
                            current_idx_selected = index;
                        }
                    }
                }
            }
            
            Slider {
            	id: verticalSlider
    			   width: (list.height >= list.contentHeight ) ? 0 : slider_width
            	orientation : Qt.Vertical
            	enabled: false
            	
            	anchors.right: parentlist.right
            	anchors.rightMargin: 5
            	
            	anchors.top: parentlist.top
            	anchors.topMargin: lineSpacing
            	
            	anchors.bottom: parentlist.bottom
            	anchors.bottomMargin: lineSpacing
            	
            	ratio: (parentlist.height * 100 ) / ( list.contentHeight + 2 * lineSpacing )            		
            }
        }

        Rectangle
        {
            id: sectionExit
            width: parent.width
            height: buttonWidth
            color: "transparent"
            
            Row {
            	anchors.horizontalCenter: parent.horizontalCenter
            	height: parent.height
            	spacing : 30
             	VirtualKeyboardButton { textDisplay:cancelText; buttonReleaseColor: "darkgrey"; txtSize: 35; actionClick.onClicked: btnCancelClicked(); width: buttonWidth }
            	VirtualKeyboardButton { textDisplay:entertext; buttonReleaseColor: "darkgrey"; txtSize: 35; actionClick.onClicked: btnOkClicked(current_idx_selected); width: buttonWidth  }
            }           
        }
    }
}
