import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
   id: container

   width: 600
   height: 100

   border.width: 3
   border.color: VColor.cViaviColorGray
   color: VColor.cViaviColorLightGray1
    
   property int buttonWidth: 160
   property int buttonHeight: 80
   property int textSize: 20
   property color original_color : VColor.cViaviColorGray
   
   property bool isEnabled: setup_data.isAvailable
	    
   Wizard_Exit_Button {
	id: exitButton
	width: buttonWidth
	height: buttonHeight
	
	anchors.verticalCenter: parent.verticalCenter
	anchors.left: parent.left
	anchors.leftMargin: 20
	
   enableLongPress: windows_manager.canGoBack
   enableBackOnClick: windows_manager.canGoBackOnClick
	
	color: container.original_color
	textDef: windows_manager.txtExit
	textsize: textSize
	durationLongTimer: 1500
	
	onPressedButton: {
	   windows_manager.Close_Setup_Windows(true); //Regular exit when pressed            
	   }  
	
	onLongPressedButton: {
	  windows_manager.Close_Setup_Windows(false); // back to the previous page         
	   }    
   }
	       
    Rectangle {
		id: standardButton
		width: buttonWidth
		height: buttonHeight
		color: VColor.cViaviColorGreen
		
		anchors.verticalCenter: parent.verticalCenter
		anchors.right: realTimeButton.left
		anchors.rightMargin: 4
		
		enabled: isEnabled
		opacity: isEnabled ? 1 : 0.4
			    
		Text {
		    color: VColor.cViaviColorWhite
		    anchors.fill: parent
		    text: windows_manager.txtStandard
		    horizontalAlignment: Text.AlignHCenter
		    verticalAlignment:  Text.AlignVCenter
		    font.pixelSize: textSize
		    wrapMode: Text.Wrap	            
		}
		
		MouseArea {
		    anchors.fill: parent
		    onClicked: {
				setup_data.Wizard_Setup_Apply_Data();
				windows_manager.Start_Acquisition(false);
		    }           
		}
    }
	   
    Rectangle {
		id: realTimeButton
		width: buttonWidth
		height: buttonHeight
		color: VColor.cViaviColorLightGreen
	    
		anchors.verticalCenter: parent.verticalCenter
		anchors.right: parent.right
		anchors.rightMargin: 20
		
		enabled: isEnabled
		opacity: isEnabled ? 1 : 0.4
	    
		Text {
		    color: VColor.cViaviColorWhite
		    anchors.fill: parent
		    text: windows_manager.txtRealTime
		    horizontalAlignment: Text.AlignHCenter
		    verticalAlignment:  Text.AlignVCenter
		    font.pixelSize: textSize
		wrapMode: Text.Wrap	            
		}
		
		MouseArea {
		    anchors.fill: parent
		    onClicked: {
				setup_data.Wizard_Setup_Apply_Data();
				windows_manager.Start_Acquisition(true);
		    }
		}
    }	    
}
