import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    id: mainContainer

    width: 500
    height: 400

    border.width: 2
    border.color: VColor.cViaviColorGray
    color: VColor.cViaviColorLightGray1

    property int rowHeigth: 50

    function openKeyBoard(title, initialText) {
        keyboard.titleText = title;
        keyboard.initialText = initialText;

        keypad.visible = false;
        keyboard.visible = true;
    }

    function openKeyPad(title, initialText, dotAllowed, minValue, maxValue) {
        keypad.titleText = title;
        keypad.initialText = initialText;
        keypad.dotIsAllowed = dotAllowed;

        if( minValue.length > 0 )
        {
            keypad.minValue = minValue;
        }
        else
        {
            keypad.minValue = "0.000";
        }

        if( maxValue.length > 0 )
        {
            keypad.maxValue = maxValue;
        }
        else
        {
            keypad.maxValue = "50000.000";
        }

        keypad.visible = true;
        keyboard.visible = false;
    }

    Text {
        id: title
        width: parent.width
        height: 25
        color: VColor.cViaviColorGray

        anchors.top: parent.top
        anchors.topMargin: 10
        anchors.left: parent.left
        anchors.leftMargin: 10
        anchors.bottomMargin: 10

        font.bold: true
        font.pixelSize: 22
        horizontalAlignment: Text.AlignHCenter
        text: windows_manager.txtRecordingInformationTitle
    }

    Rectangle {

        width: parent.width
        color: "transparent"

        anchors.left: parent.left
        anchors.leftMargin: 10
        anchors.right: parent.right
        anchors.rightMargin: 10
        anchors.top: title.bottom
        anchors.topMargin: 5
        anchors.bottom: buttonSelection.top
        anchors.bottomMargin: 5
        enabled: (keyboard.visible === false && keypad.visible === false)
        
        Column {
            anchors.fill: parent
            
            focus: true
            clip:true
            spacing: 5
    
            Repeater {
                id: choiceLine
                model: recording_information_data.itemsList
                delegate: Wizard_Recording_Information_Item {
	                style: model.modelData.style
	                label: model.modelData.label
	                value: model.modelData.data
	                key: model.modelData.key
	                min: model.modelData.min
	                max: model.modelData.max
                	onDataValidated:
	                {
	                    recording_information_data.Wizard_Recording_Info_Changed(key, value);
	                    buttonSelection.validationIsPossible = recording_information_data.Wizard_Check_Items();
	                }
            	}
            }
        }

    }

    Wizard_Recording_Information_Message_Box_Button {
        id: buttonSelection
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 10
        enabled: true
        validationIsPossible: recording_information_data.Wizard_Check_Items();
    }

    Wizard_Key_Board {
        id: keyboard
        visible: false
        anchors.fill: parent
        anchors.centerIn: parent
        displayCursor: true
    }

    Wizard_Key_Pad {
        id: keypad
        visible: false
        anchors.centerIn: parent
        minValue: "1"
        maxValue: "9999"
        dotIsAllowed: false

        onBtnOkClicked: {
            close();
        }
    }    
    
    Rectangle {
    		id: rectangle_disabled
            anchors.fill: parent
            color: VColor.cViaviColorGray
            opacity: 0.5
            visible: false
        }

    Rectangle {
        id: filename_container
        height: 200
        width: buttonSelection.width
        color: VColor.cViaviColorLightGray1    
     	  border.width: 5
    	  border.color: VColor.cViaviColorGray
        radius: 5
        
        anchors.centerIn: mainContainer
        anchors.top: parent.top
        anchors.left: parent.left
        anchors.right: parent.right
       
        visible: false
        Column {
            spacing: 15
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.leftMargin: 10
            anchors.rightMargin: 10
       		anchors.bottomMargin: 5
       		anchors.verticalCenter: parent.verticalCenter
            
            Text {
                height: 25
                width: parent.width
                color: VColor.cViaviColorBlack
                font.pixelSize: 22
                text : "Filename pattern :"
                font.bold: true                
                horizontalAlignment: Text.AlignHCenter                
            }

            Text {
            	width: parent.width
                height: 25
                color: VColor.cViaviColorBlack
                font.bold: false
                font.pixelSize: 22
                horizontalAlignment: Text.AlignHCenter
                text: recording_information_data.txtRecordingFilename
            }
        }
    }
}
