import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle
{
   id: container
   
   property int current_idx_selected : 0
   property int items_margin: 10
   
   border.width: 2
   border.color: VColor.cViaviColorBlack
   color: VColor.cViaviColorWhite
  
  ListView
  {
      id: list
      spacing: 2
      boundsBehavior: Flickable.StopAtBounds
      
      anchors.fill: parent
      anchors.topMargin: items_margin
      anchors.bottomMargin: items_margin
      anchors.leftMargin: items_margin
      anchors.rightMargin: items_margin

      highlight: Rectangle { width: list.width; color: VColor.cViaviColorMediumBlue; radius: 5 }
      highlightFollowsCurrentItem: true

      highlightMoveSpeed: -1
      highlightMoveDuration: -1
      
      currentIndex: current_idx_selected

      clip: true
      focus: true
      
      onContentYChanged: indicator.value = parseInt(contentY, 10) * 100 / contentHeight;
      onHeightChanged: indicator.ratio = (indicator.height + items_margin)  * 100 / (contentHeight);
      onContentHeightChanged: indicator.ratio = (indicator.height + items_margin)  * 100 / (contentHeight);
      
      onCurrentIndexChanged: {
         current_idx_selected = currentIndex;
      }

      model: wizard_directory.filesList
      delegate:  Text {
            	      id: h;
            	      width: list.width
         		      height: 40
         		
         		      anchors.left : parent.left
         		      anchors.leftMargin: h.ListView.isCurrentItem ? 20 : 0
            	
                     color: h.ListView.isCurrentItem ? VColor.cViaviColorWhite : VColor.cViaviColorBlack
                
                     text: modelData
                     verticalAlignment: Text.AlignVCenter
		               font.pixelSize: h.ListView.isCurrentItem ? 20 : 16
				         font.bold: h.ListView.isCurrentItem

                     MouseArea {
	                    anchors.fill: parent
	                    onClicked: {
                        current_idx_selected = index;
                       }
                     }
                }
  }
  
  Slider {
     id: indicator
     width: (visible == true) ? 5 : 0
     orientation : Qt.Vertical
     enabled: false
     
     anchors.right: parent.right
     anchors.rightMargin: items_margin           
     anchors.top: list.top 
     anchors.bottom: list.bottom
     
     visible: list.contentHeight >  list.height
     
     ratio: (list.height + items_margin)  * 100 / (list.contentHeight)
  }
}