import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    id: button
    // property text color
    property color textColor: VColor.cViaviColorWhite
    property color pressedtextColor: textColor
    property int textsize: 20
    property string textDef : "N/A"
    
    // property button
    property color pressColor
    property int durationLongTimer: 1000
    property int periodRefresh: 33
    property bool enableLongPress: true;
    property bool enableBackOnClick: false;
    property string path_img: "/acterna/storage/look-and-feel/generic/Exit_Wizard.png"

    // property scale
    
    signal pressedButton;
    signal longPressedButton;
    
    function resetButton()
    {
        canvas.width = 0
    }
    function desaturate(colorString)
    {
        return
    }

    Rectangle {
        anchors.centerIn: parent
        width: parent.width
        height: parent.height * 0.75
        anchors.topMargin: 10
        anchors.bottomMargin: 10
        color: "transparent"
        z: 1

        Text {
            id: buttonText
            color: VColor.cViaviColorWhite
            width: button.width
            text: textDef
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: textSize
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: enableLongPress == false ? parent.verticalCenter : undefined
            wrapMode: Text.Wrap
        }
        Image {
            width: 50
            height: 38
            source: path_img
            fillMode: Image.PreserveAspectFit
            visible: enableLongPress
            anchors.top: buttonText.bottom
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }


    
    MouseArea {
        id: mouseArea
        anchors.fill: parent
        onClicked: {
            if( enableBackOnClick != false )
            {
                longPressedButton();
            }
            else
            {
                pressedButton();
            }

        }
        onPressedChanged: {
            if( enableLongPress == true )
            {
               resetButton();
               if ( pressed ) {
                   longPressTimer.running = true;
                   refreshPressTimer.running = true;
               }
               else {
                   refreshPressTimer.running = false;
                   longPressTimer.running = false;
               }
            }
        }
    }
    
    Rectangle
    {
        id: canvas
        anchors.left: parent.left
        color: Qt.darker(button.color);
        width: 0
        height: parent.height
        radius: 5
        z: 0
    }
    
    Timer {
        id: refreshPressTimer
        
        interval: periodRefresh //your press-and-hold interval here
        repeat: true
        running: false
        
        
        onTriggered: {
            var incr = 0.0;
            if( canvas.width < button.width )
                incr = (button.width * periodRefresh) / durationLongTimer;
            canvas.width = canvas.width + incr;
        }
    }
    Timer {
        id: longPressTimer
        
        interval: durationLongTimer //your press-and-hold interval here
        repeat: false
        running: false
        onTriggered: {
            longPressedButton();
        }
    }
}
