import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    id: ibtn

    property int key : Qt.Key_unknown
    property bool withRepeat: false
    property string textSend: ""
    property string textDisplay: ""
    property bool isEnabled: true
    property string buttonReleaseColor: "white"
    property string buttonPressColor: VColor.cViaviColorLightBlue
    property int txtSize: 25

    property alias actionClick: clickArea

    color: buttonReleaseColor
    width: 60
    height: width
    radius: 5
    opacity: isEnabled ? 1 : 0.3

    Text {
        id: txtButton
        text: textDisplay
        font.pixelSize: txtSize

        color: "black"
        anchors.centerIn: parent
        // Tbd: Use different anchor if button pressed to move text upwards (=> not hidden under fingertip)
        clip: true
    }

    MouseArea {
        id: clickArea
        anchors.fill: parent
        enabled: isEnabled
        onClicked: {
            textSend == "" ? addText(textDisplay) : addText(textSend)
        }

        onPressed: ibtn.color = buttonPressColor
        onReleased: ibtn.color = buttonReleaseColor
    }
}
