<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTRwDto;
use app\util\SMTLogger;

/**
 * SmartOTU general settings (log level, sequensor on...)
 * 
 * @author Sylvain Desplat
 */
class SMTSmartOtuSettingsDto extends SMTRwDto
{
    /**
     * OTU RFTY OTU mode
     * @var string
     */
    const OTU_MODE = "SMARTOTU";
    
    /**
     * HDD default STATUS
     * @var string
     */
    const HDD_STATUS = "OK";
    
	/**
	 * Whether the sequensor is on
	 */
	protected $sequensorOn = FALSE;	
	
	/**
	 * SmartOTU log level
	 */
	protected $logLevel = SMTLogger::INFO;	
	
	/**
	 * shouldn't return anything but "SMARTOTU"
	 * 
	 * @var string
	 */
	protected $otuRftyMode = self::OTU_MODE;
	
	/**
	 * OTU serial number
	 * @var string
	 */
	protected $otuSerialNumber;
	
		/**
	 * OTU release version
	 * @var string
	 */
	protected $otuReleaseVersion;
	
    /**
	 * OTU type
	 * @var string
	 */
	protected $otuType;
	
	/**
	 * OTU type label
	 * @var string
	 */
	protected $otuTypeLabel;
	
	/**
	 * Software options
	 * @var string
	 */
	protected $softwareOption;
	
	/**
	 * Whether the OTU has a DTSS module
	 * 
	 * @var boolean
	 */
	protected $dtssModule = FALSE;
	
	/**
	 * HDD status
	 */
	protected $hddStatus = self::HDD_STATUS;
	
	/**
	 * @return boolean
	 */
	public function isSequensorOn()
	{
		return $this->sequensorOn;
	}
	
	/**
	 * Set smartOTU sequensor status
	 * 
	 * @param $on boolean
	 */
	public function setSequensorOn( $on )
	{
		$this->sequensorOn = $on;
	}
	
	/**
	 * @param $logLevel string
	 */
	public function setLogLevel( $logLevel )
	{
		return $this->logLevel = $logLevel;
	}
	
	/**
	 * Returns the smartOTU log level: INFO, ERROR
	 * @return boolean
	 */
	public function getLogLevel()
	{
		return $this->logLevel;
	}
	
	/**
	 * Set the OTU RFTY mode : OTU, ROTAU, OEM, ONMSI or SMARTOTU
	 * 
	 * @param $otuRftyMode string
	 */
	public function setOtuRftyMode( $otuRftyMode )
	{
		return $this->otuRftyMode = $otuRftyMode;
	}
	
	/**
	 * Returns the OTU RFTY mode : OTU, ROTAU, OEM, ONMSI or SMARTOTU
	 * @return boolean
	 */
	public function getOtuRftyMode()
	{
		return $this->otuRftyMode;
	}	
	
	/**
	 * OTU serial number
	 * 
	 * @param string $otuSerialNumber
	 */
	public function setOtuSerialNumber( $otuSerialNumber )
	{
	    $this->otuSerialNumber = $otuSerialNumber;
	}
	
	/**
	 * OTU release version
	 *
	 * @param string $otuReleaseVersion
	 */
	public function setOtuReleaseVersion( $otuReleaseVersion )
	{
		$this->otuReleaseVersion = $otuReleaseVersion;
	}

	/**
	 * OTU type
	 *
	 * @param string $otuType
	 */
	public function setOtuType( $otuType )
	{
		$this->otuType = $otuType;
	}
	
	/**
	 * OTU type label
	 *
	 * @param string $otuTypeLabel
	 */
	public function setOtuTypeLabel( $otuTypeLabel )
	{
		$this->otuTypeLabel = $otuTypeLabel;
	}
	
	/**
	 * OTU software options
	 *
	 * @param string $softwareOption
	 */
	public function setSoftwareOption( $softwareOption )
	{
		$this->softwareOption = $softwareOption;
	}	
	
	/**
	 * * Whether the OTU has a DTSS module
	 * @return boolean
	 */
	public function isDTSSModule()
	{
		return $this->dtssModule;
	}
	
	/**
	 * Whether the OTU has a DTSS module 
	 *
	 * @param $hasDtssModule boolean
	 */
	public function setDTSSModule( $hasDtssModule )
	{
		$this->dtssModule = $hasDtssModule;
	}
	
	/**
	 * HDD status
	 *
	 * @param string $hddStatus
	 */
	public function setHddStatus( $hddStatus )
	{
		$this->hddStatus= $hddStatus;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTSmartOtuSettingsDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}


?>