<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\security;

use app\services\SMTIService;

use app\admin\SMTRoleDto;

use \Luracast\Restler\iAuthenticate;
use \app\http\SMTContext;
use app\admin\SMTUserUtil;

/**
 * Authentication class
 * 
 * 
 * @author sdesplat
 */
class SMTAccessControl implements iAuthenticate
{
    /**
     * Required role names documented in api method:
     *   
     * 	* <@>access protected 
	 *  * <@>class SMTAccessControl {@requires user}
	 *  
     * They are injected by framework ( Util::setproperties ):
     * 
     * @var array
     */
	public $requires = null;	
	
	/**
	 * Control acces to a protected api method: the user must be allowed to access that method.
	 * If the user is not already logged in, try to log him, either check his role.
	 * When access control is required on a service method (all services accessed by the GWT client except the login/logout and OTU alarm, activity services ),
	 * the PHP session holding the current user is restored.
	 * 
	 * @see \Luracast\Restler\iFilter::__isAllowed()
	 */
	public function __isAllowed()
	{
	    $isAllowedToExecute = false;
	    
	    //SMTRestlerRouter injected by framework
	    $context = SMTContext::getContext( $this->restler );
	    
	    //Restore PHP session context: PHP session context must be restored to handle session time-out and user identifiers.
	    $session = $context->getSessionContext( self::isSessionTimeoutToCheck() );	    	    
	    
	    //try to login directly from http request header if the user is not already logged in
	    if ( $session->getUser() == null )
	    {
	        $userIdentifiers = $context->getHttpRequest()->decodeUserAuthorizationFromHeader();
	        if ( $userIdentifiers != null )
	        {
	            //test if user exists
	            $user = SMTUserUtil::authenticate($context, $userIdentifiers[0], "", base64_encode($userIdentifiers[1]) );	
	            $session->setUser($user);	    
	        }	        
	    }    
	    
	    // test if one required role is a role of the current user 
	    // or if the OTU is connected in local mode and the user role is not read-only
	    if ( $session->getUser() != null ) 
	    {
	        if ( is_array( $this->requires  ) )
	        {
    	        foreach ( $this->requires as $requiredRole )
    	        {
    	            if ( $session->getUser()->getRole()->isIncludingRole( $requiredRole ) || 
    	                    ( $context->isLocalMode() && !$session->getUser()->getRole()->isEqual(SMTRoleDto::USER) ) ) 
    	            {
    	                $isAllowedToExecute = true;
    	                break;
    	            }
    	        }
	        }
	        else
	        {
	            $isAllowedToExecute = $session->getUser()->getRole()->isIncludingRole( $this->requires ) || 
    	                    ( $context->isLocalMode() && !$session->getUser()->getRole()->isEqual(SMTRoleDto::USER) );
	        }
	    }
	    //if user is not authentified, return a user not authentified json error
	    else
	    {
        	$context->closeSession();
	    }
	    
	    return $isAllowedToExecute;
	}
	
	/**
	 * Filter queries where session timeout musn't be checked.
	 * Don't check session timeout for message consumer registration/un-registration
	 * 
	 * @return boolean
	 */
	private static function isSessionTimeoutToCheck()
	{
	    return !( strpos( $_SERVER["REQUEST_URI"], "/".SMTIService::MESSAGE_SERVICE."/consumer" ) !== FALSE );
	}
}
?>