<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\message;

use app\events\SMTConversationMessageFilterDto;

use app\events\SMTEventMessageManager;
use app\services\SMTIService;
use app\services\SMTService;
use app\services\security\SMTAccessControl;

/**
 * Service to long delay poll SmartOTU messages.
 * 
 *
 * @author Sylvain Desplat
 */
class SMTMessageService extends SMTService implements SMTIService
{        
    /**
     * WARNING: POLLING MUST BE DONE AS POST TO GUARANTEE THAT THE HTTP REQUEST WILL BE RECEIVED BY THE SERVER 
     *  
     * @url POST /{consumerId}
     *
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function getMessage( $consumerId )
    {
    	try
    	{
    	    $messagesDto = SMTEventMessageManager::getInstance()->getMessages( $consumerId );
    	}
    	catch ( \Exception $e )
    	{
    		$this->handleException($e);
    	}
    	return $messagesDto->getJsonData();
    }       

    /**
     *
     * @url POST /conversation/{conversationId}
     * @status 200
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function getConversationMessage( $conversationId)
    {
    	try
    	{
    		$messagesDto = SMTEventMessageManager::getInstance()->getConversationMessages( $conversationId, $this->getContext() );
    	}
    	catch ( \Exception $e )
    	{
    		$this->handleException($e);
    	}
    	return $messagesDto->getJsonData();
    }    
    /**
     *
     * @url PUT /consumer
     *
     * @access protected
     * @class SMTAccessControl {@requires user}
     */    
    public function registerConsumer( $request_data )
    {        
    	try
    	{
            $messageFilter = SMTConversationMessageFilterDto::getInstance( $request_data );        
            $messageManager = new SMTEventMessageManager();      
                   
            //register the event consumer for the given filter ( target consumer, conversation, message type)
            $messageManager->registerEventConsumer($messageFilter);
    	}
    	catch ( \Exception $e )
    	{
    		$this->handleException($e);
    	}
    	return $messageFilter;
    }
    
    /**
     * Unregister all event listeners for the given consumer
     *
     * @url DELETE /consumer/{consumerId}
     * @param string $consumerId
     */
    public function unregisterConsumer( $consumerId )    
    {
        try
        {
        	$messageManager = new SMTEventMessageManager();
        	 
        	//unregister the event consumer for the given filter ( target consumer, conversation, message type)
        	$messageManager->unregisterEventConsumer($consumerId);
        }
        catch ( \Exception $e )
        {
        	$this->handleException($e);
        }
        return $consumerId;        
    }
    
//     /**
//      * @url POST /test/messages/{consumerId}/{conversationId}/{messageType}
//      */
//     function testMessagesConsumer($consumerId, $conversationId, $messageType )
//     {
//     	$url = '/messages/consumer/'.$consumerId;
    	
    	
//     	$json_string = json_encode( $measurementDto->getJsonData() );
//     	$page = new SMTTestRestApiPage($url, $json_string, 'PUT');
//     	$this->getContext()->getHttpResponse()->send( $page );
//     }
    
    
    
}