#!/bin/sh
### BEGIN INIT INFO
# Provides:	reset-ip-monitor
# Required-Start:    $syslog
# Required-Stop:     $syslog
# Default-Start:     5
# Default-Stop:      0 1 4 6
# Short-Description: Manage the reset ip button (eotdr product like)
# Description:       A short press on reset ip should restore the CFG1 network configuration. A long presse will reboot the board and restore default configuration for Isu
### END INIT INFO

DESC="IP-Reset button monitoring"
NAME="ip-reset-monitor"
ARGS=""
DAEMON="/usr/local/bin/reset-ip-monitor.py"
PIDFILE=/var/run/reset-ip-monitor.pid

# Do not use in OTU mode
if [ -e /etc/init.d/otu_functions ] ; then
	source /etc/init.d/otu_functions
	is_cotu_hw
	[ $? -ne 0 ] && exit 0
fi

# Launch the button monitoring
case "$1" in
    start)
        echo -n "* starting $DESC: $NAME... "
        start-stop-daemon -S -b -m -p $PIDFILE -x $DAEMON -- $ARGS
        echo "done."
        ;;
    stop)
        echo -n "* stopping $DESC: $NAME... "
		if [ -f $PIDFILE ] ; then
			kill $(cat $PIDFILE)
			rm -rf $PIDFILE
		fi
        echo "done."
        ;;
    restart)
        echo "* restarting $DESC: $NAME... "
        $0 stop
        $0 start
        echo "done."
        ;;
    *)
        echo "Usage: $0 {start|stop|restart}"
        exit 1
        ;;
esac
