import QtQuick 1.1
import libfo 1.0
import "Viavi_Colors.js" as VColor

Item {
    id: container
    
    property int    style : RecordingInformationItem.ITEM_UNKNOWN;
    property alias  label : header_text_id.text;
    property alias  value: 	value_id.text;
    property int 	key: 	-1
    property string min: 	""
    property string max: 	""
    property bool isError: false

    
    signal dataValidated(string value, int key)
    
    //GUI
    width: parent.width
    height: rowHeigth
    
    property int textInputWidth: parent.width - headerWidth - headerSpacing
    property int textLength: 25
    property int textSize: 20
    property int headerWidth: 200
    property int headerSpacing: 4  
    
    Component.onCompleted: displayMustToHave()
	
    function displayMustToHave() 
    {
    	if ( (value_id.text.length === 0) || (recording_information_data.Wizard_Check_Item_From_Id(key) === false) )
	  {
	  isError = true;
	  }
     	else
	  {
	  isError = false;
	  }
    }
    
    function editText(txtOutput, validation) {   
        if (validation === true)
        {
            value_id.text = txtOutput
            dataValidated(value_id.text, key)
        }
        displayMustToHave();
        keyboard.editText.disconnect(editText);   
    }
    
    function editNumber(txtOutput, validation) {   
        if (validation === true)
        {
            value_id.text = txtOutput
            dataValidated(value_id.text, key)
        }
        displayMustToHave();        
        keypad.editText.disconnect(editNumber); 
    }
      
    
    Row {
        id: row_id
        spacing: headerSpacing
        height: parent.height
        width: parent.width
        
        
        Rectangle {
            color: VColor.cViaviColorGray
            height: parent.height
            width: headerWidth
            Text {
                id: header_text_id
                anchors.centerIn: parent
                color: VColor.cViaviColorWhite
                font.pixelSize: textSize
            }
            
            Image {
	        width: 20
	        height: 20
	      
	        visible: isError
	      
	        anchors.right: parent.right
	        anchors.rightMargin: 3
	        anchors.bottom: parent.bottom
	        anchors.bottomMargin: 3
	      
	        source: "/acterna/storage/look-and-feel/generic/Warning_Wizard.png"
                fillMode: Image.PreserveAspectFit
	    }
        }
        
        Rectangle {
        	id: border_id
            height: parent.height
            width: textInputWidth
            
            border.width: 2
            border.color: VColor.cViaviColorLogoPurple
                       
            TextInput {
                id: value_id
                height: parent.height
                anchors.fill: parent
                anchors.topMargin: 10
                horizontalAlignment: Text.AlignHCenter
                cursorVisible: false
                maximumLength: textLength
                font.pixelSize: textSize
                
                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        switch(style)
                        {
                        case RecordingInformationItem.ITEM_STRING:
	                        {
		                        keyboard.editText.connect(editText);
		                        openKeyBoard( header_text_id.text, value_id.text );                           
		                        break;
	                        }   
                        case RecordingInformationItem.ITEM_INT:
	                        {
	                        	keypad.editText.connect(editNumber);	                        
		                        openKeyPad( header_text_id.text, value_id.text, false, min, max );                           
	                            break;
	                        }
                        case RecordingInformationItem.ITEM_REAL:
	                        {
	                        	keypad.editText.connect(editNumber);	                        
	                        	openKeyPad( header_text_id.text, value_id.text, true, min, max );                           
	                            break;
	                        }
                        default:
                        case ITEM_UNKNOWN:
	                        {
	                            break;
	                        }
                        }
                    }
                }
            }
        }
    }
}
