import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    id: container
    anchors.fill: parent
    color: "lightgrey"

    width: 640
    height: 400

    // 'Public' properties
    property int maxChars: 64
    property int minChars: 1
    property string titleText: ""
    property string initialText: ""

    property bool isQwerty: true

    property string shiftText: "\u21E7"
    property string capslockText: "\u21EA"
    property string entertext:"\u23CE"
    property string clrText: "\u2421"
    property string spaceText: "Space"
    property string bspText: "\u2B05"
    property string cancelText: "\u00D7"
    property string changeText: "\u21C4"
    property string rightArrow: "\u2192"
    property string leftArrow: "\u2190"

    property bool upperKeyPressed: false
    property bool backspaceEnabled: (textInput.text.length > 0) && (textInput.cursorPosition > 0)
    property bool okButtonEnabled: textInput.text.length >= minChars
    property bool show: false

    property int labelHeight: 35
    property int txtSize: 20
    property int columnSpacing: 5
    property int lineSpacing: 8

    property int specificKeysWidth: 120
    property int keysHeight: 45

    property bool specificKeys: false
    property bool displayCursor: false

    // Signals
    signal btnOkClicked();
    signal btnCancelClicked();
    signal editText(string txtOutput, bool validation);
    
    onVisibleChanged: {
      if (visible)
	textInput.text = initialText;
    }

    onBtnOkClicked: {
	editText(textInput.text, true);
        close();
    }

    onBtnCancelClicked: {
        editText(textInput.text, false);
        close();
    }

    function close() {
        container.visible = false
    }

    // Callbacks
    function addText(text) {
        if (text == shiftText || text == capslockText) {
            upperKeyPressed = !upperKeyPressed
            return
        }
        else if (text == entertext) {
	    btnOkClicked()
            return
        }
        else if (text == cancelText) {
	    btnCancelClicked()
            return
        }
        else if (text == leftArrow) {
            textInput.cursorPosition = textInput.cursorPosition - 1 < 0 ? 0 : textInput.cursorPosition -1
            return  // Do Nothing
        }
        else if (text == rightArrow) {
            textInput.cursorPosition = textInput.cursorPosition + 1
            return  // Do Nothing
        }

        var pos = textInput.cursorPosition
        var len = textInput.text.length

        // Trick to not enter empty texts but space bar
        if (text == " ")
        {
            text = ""
        }
        else if (text == spaceText)
        {
            text = " "
        }

        switch (text) {
        case clrText:
            textInput.text = ""
            break;
        case bspText:
            if (len > 0 && pos > 0) {
                textInput.text = textInput.text.slice(0, pos - 1) + textInput.text.slice(pos, len)
                textInput.cursorPosition = pos - 1 < 0 ? 0 : pos -1
            }
            break;
        default:
            textInput.text = textInput.text.slice(0, pos) + text + textInput.text.slice(pos, len)
            textInput.cursorPosition = pos + text.length
            break;
        }
    }

    Rectangle  {
        id: titleKeyBoard
        width: parent.width - 36
        height: labelHeight
        anchors.rightMargin: 12
        anchors.right: parent.right
        anchors.leftMargin: 12
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.topMargin: 5
//        border.color: "grey"
//        border.width: 2
		color: parent.color

        Text {
            id: txtTitleKeyboard
            text: titleText
            anchors.topMargin: 4
            anchors.fill: parent
            font.pixelSize: txtSize
            horizontalAlignment: Text.AlignHCenter
            clip: true
        }
    }

    Rectangle  {
        id: labelText
        width: parent.width - 36
        height: labelHeight
        anchors.rightMargin: 12
        anchors.right: parent.right
        anchors.leftMargin: 12
        anchors.left: parent.left
        anchors.top: titleKeyBoard.bottom
//        anchors.topMargin: 10
        border.color: "red"
        border.width: 2
        radius: 3

        TextInput {
            id: textInput
            //text: initialText
            anchors.fill: parent
            anchors.leftMargin: 8
            anchors.topMargin: 5
            font.pixelSize: txtSize
            horizontalAlignment: Text.AlignLeft
            focus: true
            clip: true
            maximumLength: maxChars
            cursorVisible: displayCursor
        }
    }

   VirtualKeyboard_Qwerty {
       id: keyboardQwerty

       anchors.left: labelText.left
       anchors.top: labelText.bottom
       anchors.topMargin: 20
       upperKey: upperKeyPressed
   }

    Column {
        id: colBeta
        anchors.top: labelText.bottom
        anchors.topMargin: 20
        anchors.right: labelText.right
        spacing: lineSpacing

        VirtualKeyboardButton { textDisplay:bspText; buttonReleaseColor: "darkgrey"; txtSize: 35 }
        VirtualKeyboardButton { textDisplay:clrText; buttonReleaseColor: "darkgrey"; txtSize: 35 }
        VirtualKeyboardButton { textDisplay:cancelText; buttonReleaseColor: "darkgrey"; txtSize: 35;}
        VirtualKeyboardButton { textDisplay:entertext; buttonReleaseColor: "darkgrey"; txtSize: 35;}
    }
}
