import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
   id: container

   gradient: Gradient {
        GradientStop { position: 0.0; color: VColor.cViaviColorMediumBlue }
        GradientStop { position: 1.0; color: VColor.cViaviColorLightBlue }
   }

   Rectangle {
       width: 480
       height: 150
       
       anchors.bottom: parent.verticalCenter
       anchors.horizontalCenter: parent.horizontalCenter
       
       color: "transparent"
   
       Rectangle {
           id: standardButton
           width: 200
           height: 100
           radius: 5
           color: VColor.cViaviColorGreen
   
           anchors.verticalCenter: parent.verticalCenter
           anchors.left: parent.left
           anchors.leftMargin: 20
   
           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: windows_manager.txtStandard
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: 20
           }
           
           MouseArea {
               anchors.fill: parent
               onClicked: {
                  windows_manager.Start_Acquisition(false);
               }
           }
       }
   
       Rectangle {
           id: loadWizard
           width: 200
           height: 100
           radius: 5
           color: VColor.cViaviColorYellow
   
           anchors.verticalCenter: parent.verticalCenter
           anchors.right: parent.right
           anchors.rightMargin: 20
   
           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: windows_manager.txtRealTime
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: 20
           }
           
           MouseArea {
               anchors.fill: parent
               onClicked: {
                  windows_manager.Start_Acquisition(true);
               }
           }
       }
   }
   
   Rectangle {
       id: explanationMessage
      
       width: 600
       height: 100
      
       anchors.top: parent.verticalCenter
       anchors.topMargin: 40
       anchors.horizontalCenter: parent.horizontalCenter
      
       border.width: 2
       border.color: VColor.cViaviColorLogoPurple
       
       color: "transparent"
      
       Text {
         color: VColor.cViaviColorWhite
         anchors.centerIn: parent
         horizontalAlignment: Text.AlignLeft
         
         text: windows_manager.txtDescriptionAcquisitionModeWindow
         font.pixelSize: 16
       }
   }
}
