import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
	id: container
	
    width: 650
    height: 120
                
	visible: false
	
	property int groupe_size: 0
	property int fiber_start_index: 0
	
    color: VColor.cViaviColorGray2
    border.color: VColor.cViaviColorBlack
    border.width: 5

    GridView {
    	width: cellWidth * ( groupe_size > 12 ? 12 : groupe_size )
    	height: cellHeight * ( groupe_size > 12 ? 2 : 1 )

	    //cellWidth: 52
        //cellHeight: 52
        
        cellWidth: ( groupe_size > 4 ? 52 : 100 )
        cellHeight: cellWidth
	    
	    anchors.horizontalCenter: parent.horizontalCenter
	    anchors.verticalCenter: parent.verticalCenter
	    
	    clip: true
	    interactive: false
	    
	    model: groupe_size
		delegate: Cable_Co_Enterprise_Port { fiber_index: fiber_start_index + index;}
	}
}
