<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\view;

use app\util\SMTIOException;

use app\services\otdr\SMTOtdrTraceDto;

/**
 * Flush the otdr trace buffer for the given otdr trace file name in an otdr trace DTO.
 *
 * @author Sylvain Desplat
 */
class SMTOtdrTracePage implements SMTIPage
{
	private $otdrTracefileName;
	private $otdrTraceType;
	
	/**
	 * Construct the builder of otdr trace DTO.
	 * 
	 * @param string $otdrTracefileName otdr file name with its full path
	 * @param string $otdrTraceType SMTOtdrTraceType::OTU_REFERENCE_TRACE, SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE, SMTOtdrTraceType::LAST_TEST_ACQUISITION_TRACE
	 * 
	 */
	function __construct( $otdrTracefileName, $otdrTraceType )
	{
		$this->otdrTracefileName = $otdrTracefileName;
		$this->otdrTraceType = $otdrTraceType;
	}

	/**
	 * Flush the otdr trace buffer encoded in hexadecimal for the given otdr trace file name
	 *
	 */
	function generatePage()
	{	    
	    //test file exists:
        if( ($handle = fopen($this->otdrTracefileName ,"rb")) != FALSE )
        {
            //construct DTO trace object
            $traceDto = new SMTOtdrTraceDto();
            $traceDto->setOtdrTraceName( basename( $this->otdrTracefileName ) );
            $traceDto->setOtdrTraceType( $this->otdrTraceType );
                        
        	//open buffering
        	ob_start();
        	header('Content-Type: application/json;');
        	header('Cache-Control: no-cache, must-revalidate');
        	header('Expires: Mon, 03 Jan 2000 01:00:00 GMT');        	
        	$buffer= '';
            
            while ( !feof($handle) ) 
            {
                //read 32 bytes by 32 bytes (up to 32 bytes for the last remaining bytes) to speedup reading
                $buffer .= bin2hex( fread($handle , 32 ) );
            }
            
            $traceDto->setOtdrTraceBuffer($buffer);
            
            echo json_encode( $traceDto->getJsonData() );
            
            fclose($handle);     

            //end buffering and flush
            return ob_end_flush();
        }
        else
        {
            throw new SMTIOException( SMTIOException::FILE_NOT_FOUND, $this->otdrTracefileName );
        }
	}
}
?>