<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\view;

use app\util\SMTIOException;


/**
 * Flush the snapshot buffer.
 *
 * @author Sylvain Desplat
 */
class SMTFileDownloadPage implements SMTIPage
{
	private $fileName;
	
	const DOWNLOAD_TOKEN = "downloadToken";
	
	/**
	 * Construct the builder to download the given file.
	 * 
	 * @param string $fileName
	 * 
	 */
	function __construct( $fileName )
	{
		$this->fileName = $fileName;
	}

	/**
	 * Flush the file buffer
	 *
	 */
	function generatePage()
	{	    
	    //test file exists:
        //if( ($handle = fopen($this->fileName ,"r")) != FALSE )
        if ( file_exists($this->fileName) )
        {
            header('Content-Description: File Transfer');
         	header('Content-Type: application/octet-stream');
         	header('Content-Disposition: attachment; filename="'.basename( $this->fileName ).'"');
         	header('Content-Length: ' . filesize($this->fileName));
         	header("Content-Transfer-Encoding: binary");
         	header('Cache-Control: no-cache, must-revalidate');
         	header('Expires: 0');         	         	       
         	//open buffering
        	ob_start();            
        	readfile($this->fileName);
//         	exit;
//             while ( !feof($handle) ) 
//             {
//                 echo fread($handle , 8192 );
//             }            
//             fclose($handle);     

            //end buffering and flush
            return ob_end_flush();
        }        
        else
        {
        	throw new SMTIOException( SMTIOException::FILE_NOT_FOUND, $this->fileName );
        }        
	}
}
?>