<?php
namespace app\util\upload;

require_once('SMTUpload.php');

use app\util\SMTLogger;
use app\serviceshelper\maintenance\SMTOtuBackupRestore;
use app\services\maintenance\SMTUploadStatusDto;
use app\util\upload\SMTUploadStatus;

/**
 * Begining of upload script
 * 
 */
//15 mns script timeout ( OTU backup max size =~ 50Mo at rate 500kb/s )
set_time_limit(900);

$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( $noUploadRunning )
{
    $uploadStatus = upload_file( SMTOtuBackupRestore::OTU_BACKUP_DIR, TRUE );    
    
    if ( $uploadStatus->getUploadErrorStatus() == SMTUploadStatusDto::NO_ERROR )
    {
        //clean up all other backups
        
    }
}
else
{   
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
    SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>