<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\util;

/**
 * Interface for data objects.
 * Dto classes can be exchanged with the client application.
 * They can be serialized as json strings. 
 * Defines contract to serialize object properties as a json string.
 * 
 * @author Sylvain Desplat
 */
interface SMTIDto
{   
    /**
     * Returns Dto class name.
     * 
     * @return string the dtop class name
     */
    function getDtoClassName();
    
    /**
     * Serialize as a Json string the object extending that class.<br>
     * That method must call serializeObjectAsJsonData to serialize all its properties.
     * 
     * @return the object properties serialized as a Json string
     * @see \app\http\SMTISerializable::getSerializableProperties()
     */
    function getJsonData();
    
    /**
     * Serialize as Json data an object which is a property of the current instance.<br> 
     * That method is recursively called by getJsonData();
     * 
     * @param var $objectProperties 
     */
    function serializeObjectAsJsonData( &$objectProperties );       
}

?>