<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\maintenance;

use app\util\SMTIOException;

use app\util\SMTLogger;
use app\serviceshelper\SMTServiceHelper;
use app\util\SMTUtil;

/**
 *
 * @author Sylvain Desplat
 */
class SMTCertificate extends SMTServiceHelper
{
    const SSH_AUTHORIZED_PUBLIC_KEYS = "/root/.ssh/authorized_keys";
    const UPDATE_SSH_AUTHORIZED_PUBLIC_KEYS_CMD = "sudo /usr/lib/jdsu/scripts/otu_update_ssh_authorized_keys.sh %s";
    const READ_SSH_AUTHORIZED_PUBLIC_KEYS_CMD = "sudo /usr/lib/jdsu/scripts/otu_read_ssh_authorized_keys.sh";
    const COPY_CERTFICATE_FILE_CMD = "sudo /usr/lib/jdsu/scripts/smartotu_copy_files.sh %s %s";
    /**
     * Read ssh public keys file
     * 
     * @return The ssh authorized file as an array of string
     */
    function readSshPublicKeys()
    {
        $lines = array();

        $command = self::READ_SSH_AUTHORIZED_PUBLIC_KEYS_CMD;
        $handle = popen($command, 'r');
        SMTLogger::getInstance()->trace( sprintf("command: %s.", $command ), SMTLogger::DEBUG);
        
        while (!feof($handle)) 
        {
        	$data = fgets($handle);
        	$data = trim( str_replace('\n',"",$data) );
        	if ( $data !== "" )
        	{
        	    array_push($lines, $data);
        	    SMTLogger::getInstance()->trace( sprintf("data: %s.", $data ), SMTLogger::DEBUG);
        	}
        }

        return $lines;
    }
    
    /**
     * Save the ssh public keys from an array of string
     * 
     * @param array
     */
    function updateSshPublicKeys( $lines )
    {
        $success = -1;
        $keys = "";
        foreach ($lines as $line)
        {
            $keys.= $line."\n";
        	SMTLogger::getInstance()->trace( sprintf("New ssh key: %s.", $line ), SMTLogger::PINFO);
        }
        
        $command = sprintf(self::UPDATE_SSH_AUTHORIZED_PUBLIC_KEYS_CMD, SMTUtil::escapeShellArgUtf8($keys) );
        SMTLogger::getInstance()->trace( sprintf("command: %s.", $command ), SMTLogger::INFO);
        
        // update ssh keys
        $value = exec ($command, $output, $success);
        
        SMTLogger::getInstance()->trace(sprintf("update ssh keys output: %s success %s", $value, $success) );
        
        // 0 -> update ssh keys OK, otherwise KO
        if ($success !== 0) 
        {
            throw new SMTIOException(SMTIOException::INVALID_FILE, "update ssh keys");
        }         
    }
    
    /**
     * copy ssl certficates to their target directory
     *
     * @param $filename The name of the certificate file
     *
     */
    static function copySslCertificate($fileName, $certificateType)
    {
    	$fullPath = SMTUtil::SMARTOTU_TEMP_DIR.$fileName;
    	$success = -1;
    	
    	try
    	{
    		if ( file_exists( $fullPath) )
    		{
    			$command = sprintf(self::COPY_CERTFICATE_FILE_CMD, SMTUtil::escapeShellArgUtf8($fullPath), SMTUtil::escapeShellArgUtf8($certificateType) );
    			SMTLogger::getInstance()->trace( sprintf("command: %s.", $command ), SMTLogger::INFO);
    			 
    			// update ssh keys
    			$value = exec ($command, $output, $success);
    			 
    			SMTLogger::getInstance()->trace(sprintf("copy uploaded certificate file output: %s success %s", $value, $success) );
    			 
    			// 0 -> update license OK, otherwise KO
    			if ($success !== 0)
    			{
    				throw new SMTIOException(SMTIOException::INVALID_FILE, "failed to copy uploaded certificate file");
    			}
    		}
    		else
    		{
    			throw new SMTIOException(SMTIOException::FILE_NOT_FOUND, sprintf("uploaded certificate file %s not found", $fullPath) );
    		}
    	}
    	catch ( \Exception $e )
    	{
    		SMTLogger::getInstance()->traceException( $e );
    		throw $e;
    	}
    }    
    
}
?>
