<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTDto;
use app\settings\SMTSmartOTUStatusValues;

/**
 * OTU general status (options activated, all otu status...)
 * 
 * @author Sylvain Desplat
 */
class SMTOtuStatusDto extends SMTDto
{        
    /**
     * Whether modem option is available
     * @var boolean
     */
	protected $smsOptionValid = FALSE;	

	/**
	 * Whether the system is going down for reboot
	 */
	protected $isRebooting = FALSE;	
	
	/**
	 * Whether the OTU application is available
	 */
	protected $isOTUAvailable = FALSE;

	/**
	 * Whether the OTU application is starting
	 */
	protected $isOTUStarting= FALSE;
	
	/**
	 * Whether the OTU application is under upgrade
	 */
	protected $isOTUUpgrade= FALSE;
	
	/**
	 * Whether the OTU is in local mode
	 */
	protected $islocalMode = FALSE;	

	/**
	 * Whether the OTU is in rescue mode
	 */
	protected $isOTURescue = FALSE;
	/**
	 * Whether OTU module config is OK
	 */
	protected $moduleConfigOK = FALSE;
	/**
	 * Whether OTU switch config is OK
	 */
	protected $switchConfigOK = FALSE;
	/**
	 * Whether the sequensor is on
	 */
	protected $sequensorOn = FALSE;
	
	/**
	 * @return boolean
	 */
	public function isSequensorOn()
	{
		return $this->sequensorOn;
	}
	
	/**
	 * Set smartOTU sequensor status
	 *
	 * @param $on boolean
	 */
	public function setSequensorOn( $on )
	{
		$this->sequensorOn = $on;
	}
	/**
	 * @param boolean $moduleConfigOK
	 */
	public function setModuleConfigOK( $moduleConfigOK )
	{
		$this->moduleConfigOK = $moduleConfigOK;
	}
	
	/**
	 * @return boolean
	 */
	public function isModuleConfigOK()
	{
		return $this->moduleConfigOK;
	}
	/**
	 * @param boolean $switchConfigOK
	 */
	public function setSwitchConfigOK( $switchConfigOK )
	{
		$this->switchConfigOK = $switchConfigOK;
	}
	
	/**
	 * @return boolean
	 */
	public function isSwitchConfigOK()
	{
		return $this->switchConfigOK;
	}
	
	/**
	 * @param boolean $valid
	 */
	public function setSmsOption ( $smsOptionValid )
	{
		$this->smsOptionValid = $smsOptionValid;
	}
	
	/**
	 * @return boolean
	 */
	public function isSmsOptionValid()
	{
		return $this->smsOptionValid;
	}
	
	/**
	 * Set smartOTU status among the SMTSmartOTUStatusValues possible values
	 * 
	 * @param string $otuStatus
	 */
	public function setSmartOTUStatus ( $otuStatus )
	{
		$this->isRebooting = ( SMTSmartOTUStatusValues::REBOOT == $otuStatus );
		$this->isOTUAvailable = ( SMTSmartOTUStatusValues::OK == $otuStatus || SMTSmartOTUStatusValues::LOCAL_MODE == $otuStatus );
		$this->islocalMode = ( SMTSmartOTUStatusValues::LOCAL_MODE == $otuStatus );
		$this->isOTUStarting = ( SMTSmartOTUStatusValues::OTU_STARTING == $otuStatus );
		$this->isOTUUpgrade = ( SMTSmartOTUStatusValues::OTU_UPGRADING == $otuStatus );
		$this->isOTURescue = ( SMTSmartOTUStatusValues::RESCUE_MODE == $otuStatus );
	}
	
	/**
	 * @return boolean
	 */
	public function isRebooting()
	{
		return $this->isRebooting;
	}
	
	/**
	 * Whether the OTU application is available
	 * @return boolean
	 */
	public function isOTUAvailable()
	{
		return $this->isOTUAvailable;
	}

	/**
	 * Whether the OTU application is starting
	 * @return boolean
	 */
	public function isOTUStarting()
	{
		return $this->isOTUStarting;
	}
		
	/**
	 * Whether the OTU application is under upgrade
	 * @return boolean
	 */
	public function isOTUUpgrade()
	{
		return $this->isOTUUpgrade;
	}
	
	/**
	 * @return boolean
	 */
	public function islocalMode()
	{
		return $this->islocalMode;
	}	
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}


?>